/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.drivers.reflex;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.drivers.edtcl.CLImage;
import org.lsst.ccs.drivers.edtcl.CLSerial;
import org.lsst.ccs.drivers.edtcl.EDTException;
import org.lsst.ccs.drivers.reflex.AD8X100Control;
import org.lsst.ccs.drivers.reflex.BackplaneControl;
import org.lsst.ccs.drivers.reflex.BiasControl;
import org.lsst.ccs.drivers.reflex.BoardControl;
import org.lsst.ccs.drivers.reflex.DriverControl;
import org.lsst.ccs.drivers.reflex.InterfaceControl;
import org.lsst.ccs.drivers.reflex.PowerBControl;
import org.lsst.ccs.drivers.reflex.ReflexStatus;
import org.lsst.ccs.drivers.reflex.SystemControl;

public class ReflexController {
    ReflexStatus lastStatus;
    BoardControl[] controls = new BoardControl[13];

    String sendCommand(String cmd) throws DriverException {
        String rep = null;
        try {
            rep = CLSerial.sendCommand(cmd);
            if (rep.startsWith("<")) {
                return rep;
            }
            throw new DriverException("Reflex invalid answer " + rep);
        }
        catch (Exception e) {
            System.out.println("serial comm problem, retrying");
            e.printStackTrace();
            try {
                CLSerial.sendCommand(null);
            }
            catch (EDTException ee) {
                ee.printStackTrace();
            }
            rep = CLSerial.sendCommand(cmd);
            if (rep.startsWith("<")) {
                return rep;
            }
            throw new DriverException("Reflex invalid answer " + rep);
        }
    }

    public void reboot() throws DriverException {
        CLSerial.writeCommand(">REBOOT");
    }

    public void warmboot() throws DriverException {
        CLSerial.writeCommand(">WARMBOOT");
    }

    public int readRegister(int register) throws DriverException {
        String cmd = String.format(">R%08X", register);
        String rep = this.sendCommand(cmd);
        if (rep.charAt(0) == '<') {
            long l = Long.parseLong(rep.substring(1), 16);
            int i = l > 0x7FFFFFFL ? (int)(l - 0x100000000L) : (int)l;
            return i;
        }
        throw new DriverException("invalid response from CameraLink: " + rep);
    }

    public int getSystemState() throws DriverException {
        String rep = this.sendCommand(">TS");
        if (rep.charAt(0) == '<') {
            return Integer.parseInt(rep.substring(1), 16);
        }
        throw new DriverException("invalid response from CameraLink: " + rep);
    }

    void checkEmptyResponse(String rep) throws DriverException {
        if (!rep.equals("<")) {
            throw new DriverException("invalid response from CameraLink: " + rep);
        }
    }

    public void writeRegister(int register, int value) throws DriverException {
        String cmd = String.format(">W%08X%08X", register, value);
        String rep = this.sendCommand(cmd);
        this.checkEmptyResponse(rep);
    }

    public void clearError() throws DriverException {
        this.checkEmptyResponse(this.sendCommand(">E"));
    }

    public void configureAll() throws DriverException {
        this.checkEmptyResponse(this.sendCommand(">A"));
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public void configureSystem() throws DriverException {
        this.checkEmptyResponse(this.sendCommand(">C"));
    }

    public void configureBoard(BoardSlot b) throws DriverException {
        this.configureBoard(b.num);
    }

    public void configureBoard(int board) throws DriverException {
        String cmd = String.format(">B%1X", board);
        this.checkEmptyResponse(this.sendCommand(cmd));
    }

    public void powerOn() throws DriverException {
        this.checkEmptyResponse(this.sendCommand(">P1"));
    }

    public void powerOff() throws DriverException {
        this.checkEmptyResponse(this.sendCommand(">P0"));
    }

    public void timingGo() throws DriverException {
        this.checkEmptyResponse(this.sendCommand(">TG"));
    }

    public void timingHalt() throws DriverException {
        this.checkEmptyResponse(this.sendCommand(">TH"));
    }

    public void timingLoadParameters() throws DriverException {
        this.checkEmptyResponse(this.sendCommand(">TP"));
    }

    public void setTimingLoadAddress(int addr) throws DriverException {
        String cmd = String.format(">TA%03X", addr);
        this.checkEmptyResponse(this.sendCommand(cmd));
    }

    public void loadTimingLine(String line) throws DriverException {
        String cmd = String.format(">T%s", line);
        this.checkEmptyResponse(this.sendCommand(cmd));
    }

    public void pollStatus() throws DriverException {
        this.checkEmptyResponse(this.sendCommand(">L2"));
    }

    public ReflexStatus getStatus() throws DriverException {
        int i;
        this.pollStatus();
        ReflexStatus s = new ReflexStatus();
        s.errorCode = this.readRegister(0);
        s.errorSource = this.readRegister(1);
        s.errorLine = this.readRegister(2);
        s.statusIndex = this.readRegister(3);
        s.powerState = this.readRegister(4);
        for (i = 0; i < 12; ++i) {
            s.boardTypes[i] = this.readRegister(5 + i);
        }
        for (i = 0; i < 12; ++i) {
            s.romID[i] = this.readRegister(17 + i);
        }
        for (i = 0; i < 12; ++i) {
            s.buildNumber[i] = this.readRegister(29 + i);
        }
        for (i = 0; i < 12; ++i) {
            s.featureFlags[i] = this.readRegister(41 + i);
        }
        for (i = 0; i < 12; ++i) {
            BoardType bt = s.getBoardType(i);
            ReflexStatus.BoardStatus bs = null;
            int pfx = i + 1 << 16;
            switch (bt) {
                case SYSTEM: {
                    break;
                }
                case BACKPLANE_X6: {
                    ReflexStatus.BackplaneStatus bps = new ReflexStatus.BackplaneStatus();
                    bps.status = this.readRegister(65537);
                    bs = bps;
                    break;
                }
                case CAMERALINK: {
                    bs = new ReflexStatus.InterfaceStatus();
                    break;
                }
                case POWERA: {
                    ReflexStatus.PowerAStatus pas = new ReflexStatus.PowerAStatus();
                    pas.V5VD = this.readRegister(196609);
                    pas.I5VD = this.readRegister(196610);
                    pas.V5VA = this.readRegister(196611);
                    pas.I5VA = this.readRegister(196612);
                    pas.Vm5V = this.readRegister(196613);
                    pas.Im5V = this.readRegister(196614);
                    bs = pas;
                    break;
                }
                case POWERB: {
                    ReflexStatus.PowerBStatus pbs = new ReflexStatus.PowerBStatus();
                    pbs.V30V = this.readRegister(262145);
                    pbs.I30V = this.readRegister(262146);
                    pbs.V15V = this.readRegister(262147);
                    pbs.I15V = this.readRegister(262148);
                    pbs.Vm15V = this.readRegister(262149);
                    pbs.Im15V = this.readRegister(262150);
                    pbs.TECSetPoint = this.readRegister(262151);
                    pbs.TECActual = this.readRegister(262152);
                    bs = pbs;
                    break;
                }
                case AD8X120: {
                    ReflexStatus.AD8X120Status ad120 = new ReflexStatus.AD8X120Status();
                    ad120.status = this.readRegister(pfx + 1);
                    bs = ad120;
                    break;
                }
                case AD8X100: {
                    ReflexStatus.AD8X100Status ad100 = new ReflexStatus.AD8X100Status();
                    ad100.status = this.readRegister(pfx + 1);
                    bs = ad100;
                    break;
                }
                case DRIVER: {
                    ReflexStatus.DriverStatus ds = new ReflexStatus.DriverStatus();
                    ds.status = this.readRegister(pfx + 1);
                    bs = ds;
                    break;
                }
                case BIAS: {
                    ReflexStatus.BiasStatus bis = new ReflexStatus.BiasStatus();
                    bis.status = this.readRegister(pfx + 1);
                    for (int j = 0; j < 8; ++j) {
                        bis.lv[j] = this.readRegister(pfx + j + 2);
                        bis.hv[j] = this.readRegister(pfx + j + 10);
                        bis.lc[j] = this.readRegister(pfx + j + 18);
                        bis.hc[j] = this.readRegister(pfx + j + 26);
                    }
                    bs = bis;
                    break;
                }
                case NONE: {
                    bs = null;
                }
            }
            if (bs != null) {
                try {
                    bs.temperature = this.readRegister(pfx);
                }
                catch (Exception e) {
                    System.out.println(e);
                }
            }
            s.boardStatus[i] = bs;
        }
        this.lastStatus = s;
        return s;
    }

    public ReflexController() throws DriverException {
        this.getStatus().checkRevisions();
        this.clearError();
        this.controls[0] = new SystemControl(this, BoardSlot.SYSTEM);
        block8: for (int i = 0; i < 12; ++i) {
            switch (this.lastStatus.getBoardType(i)) {
                case BACKPLANE_X6: {
                    this.controls[i + 1] = new BackplaneControl(this, BoardSlot.forInt(i));
                    continue block8;
                }
                case CAMERALINK: {
                    this.controls[i + 1] = new InterfaceControl(this, BoardSlot.forInt(i));
                    continue block8;
                }
                case POWERB: {
                    this.controls[i + 1] = new PowerBControl(this, BoardSlot.forInt(i));
                    continue block8;
                }
                case AD8X100: {
                    this.controls[i + 1] = new AD8X100Control(this, BoardSlot.forInt(i));
                    continue block8;
                }
                case DRIVER: {
                    this.controls[i + 1] = new DriverControl(this, BoardSlot.forInt(i));
                    continue block8;
                }
                case BIAS: {
                    this.controls[i + 1] = new BiasControl(this, BoardSlot.forInt(i));
                    continue block8;
                }
                default: {
                    this.controls[i + 1] = null;
                }
            }
        }
    }

    public BoardControl[] getControls() {
        return this.controls;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void acquireImages(int w, int h, int n, final ImageHandler handler, boolean async) throws DriverException {
        try {
            CLImage.setup(w, h);
            CLImage.start(n);
            if (async) {
                ExecutorService exec = Executors.newFixedThreadPool(2);
                int i = 0;
                while (i < n) {
                    handler.startingAcq(i);
                    final short[][] img = CLImage.getImage();
                    final int j = i++;
                    exec.execute(new Runnable(){

                        @Override
                        public void run() {
                            handler.handleImage(j, img);
                        }
                    });
                }
                exec.shutdown();
                exec.awaitTermination(10L, TimeUnit.SECONDS);
            } else {
                for (int i = 0; i < n; ++i) {
                    short[][] img = CLImage.getImage();
                    handler.handleImage(i, img);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            CLImage.close();
        }
    }

    public static void main(String[] args) throws DriverException {
        ReflexController c = new ReflexController();
        ReflexStatus s = c.getStatus();
        s.dump();
    }

    public static enum BoardSlot {
        SYSTEM(-1),
        BACKPLANE(0),
        INTERFACE(1),
        POWERA(2),
        POWERB(3),
        DM1(4),
        DM2(5),
        DM3(6),
        DM4(7),
        DM5(8),
        DM6(9);

        int num;

        private BoardSlot(int num) {
            this.num = num;
        }

        public static BoardSlot forInt(int num) {
            for (BoardSlot b : BoardSlot.values()) {
                if (b.num != num) continue;
                return b;
            }
            throw new IllegalArgumentException(Integer.toString(num));
        }

        public int getSlotNum() {
            return this.num;
        }
    }

    public static enum BoardType {
        SYSTEM(-1),
        NONE(0),
        BACKPLANE_X6(16),
        CAMERALINK(32),
        POWERA(48),
        POWERB(64),
        AD8X120(80),
        AD8X100(81),
        DRIVER(96),
        BIAS(112);

        int tt;

        private BoardType(int tt) {
            this.tt = tt;
        }

        public static BoardType forType(int tt) {
            for (BoardType b : BoardType.values()) {
                if (b.tt != tt) continue;
                return b;
            }
            throw new IllegalArgumentException(Integer.toString(tt));
        }
    }

    public static interface ImageHandler {
        public void startingAcq(int var1);

        public void handleImage(int var1, short[][] var2);
    }
}

