/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.drivers.reflex;

import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.drivers.reflex.BoardControl;
import org.lsst.ccs.drivers.reflex.ReflexController;

public class PowerBControl
extends BoardControl {
    PowerBControl(ReflexController ctl, ReflexController.BoardSlot slot) {
        super(ctl, slot);
    }

    @Override
    public ReflexController.BoardType getBoardType() {
        return ReflexController.BoardType.POWERB;
    }

    public void setTECSetPoint(int x) throws DriverException {
        this.ctl.writeRegister(this.baseAddress, x);
    }

    public int getTECSetPoint() throws DriverException {
        return this.ctl.readRegister(this.baseAddress);
    }

    public void setTempControl(int ab, int x) throws DriverException {
        this.ctl.writeRegister(this.baseAddress + 1 + ab, x);
    }

    public void setTempTarget(int ab, int x) throws DriverException {
        this.ctl.writeRegister(this.baseAddress + 3 + ab, x);
    }

    public void setTempP(int ab, int x) throws DriverException {
        this.ctl.writeRegister(this.baseAddress + 5 + ab, x);
    }

    public void setTempI(int ab, int x) throws DriverException {
        this.ctl.writeRegister(this.baseAddress + 7 + ab, x);
    }

    public void setTempD(int ab, int x) throws DriverException {
        this.ctl.writeRegister(this.baseAddress + 9 + ab, x);
    }

    public void setTempForce(int ab, int x) throws DriverException {
        this.ctl.writeRegister(this.baseAddress + 11 + ab, x);
    }

    public int getTempControl(int ab) throws DriverException {
        return this.ctl.readRegister(this.baseAddress + 1 + ab);
    }

    public int getTempTarget(int ab) throws DriverException {
        return this.ctl.readRegister(this.baseAddress + 3 + ab);
    }

    public int getTempP(int ab) throws DriverException {
        return this.ctl.readRegister(this.baseAddress + 5 + ab);
    }

    public int getTempI(int ab) throws DriverException {
        return this.ctl.readRegister(this.baseAddress + 7 + ab);
    }

    public int getTempD(int ab) throws DriverException {
        return this.ctl.readRegister(this.baseAddress + 9 + ab);
    }

    public int getTempForce(int ab) throws DriverException {
        return this.ctl.readRegister(this.baseAddress + 11 + ab);
    }
}

