/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.drivers.reflex;

import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.drivers.reflex.BoardControl;
import org.lsst.ccs.drivers.reflex.ReflexController;

public class BiasControl
extends BoardControl {
    BiasControl(ReflexController ctl, ReflexController.BoardSlot slot) {
        super(ctl, slot);
    }

    @Override
    public ReflexController.BoardType getBoardType() {
        return ReflexController.BoardType.DRIVER;
    }

    public void setBiasEnable(int bitfield) throws DriverException {
        this.ctl.writeRegister(this.baseAddress, bitfield);
    }

    public int getBiasEnable() throws DriverException {
        return this.ctl.readRegister(this.baseAddress);
    }

    public void setLVVoltage(int channel, int v) throws DriverException {
        this.ctl.writeRegister(this.baseAddress + 1 + (channel - 1), v);
    }

    public int getLVVoltage(int channel) throws DriverException {
        return this.ctl.readRegister(this.baseAddress + 1 + (channel - 1));
    }

    public void setHVVoltage(int channel, int v) throws DriverException {
        this.ctl.writeRegister(this.baseAddress + 9 + (channel - 1), v);
    }

    public int getHVVoltage(int channel) throws DriverException {
        return this.ctl.readRegister(this.baseAddress + 9 + (channel - 1));
    }

    public void setLVCurrent(int channel, int v) throws DriverException {
        this.ctl.writeRegister(this.baseAddress + 17 + (channel - 1), v);
    }

    public int getLVCurrent(int channel) throws DriverException {
        return this.ctl.readRegister(this.baseAddress + 17 + (channel - 1));
    }

    public void setHVCurrent(int channel, int v) throws DriverException {
        this.ctl.writeRegister(this.baseAddress + 25 + (channel - 1), v);
    }

    public int getHVCurrent(int channel) throws DriverException {
        return this.ctl.readRegister(this.baseAddress + 25 + (channel - 1));
    }

    public void setLVOrder(int channel, int order) throws DriverException {
        this.ctl.writeRegister(this.baseAddress + 33 + (channel - 1), order);
    }

    public int getLVOrder(int channel) throws DriverException {
        return this.ctl.readRegister(this.baseAddress + 33 + (channel - 1));
    }

    public void setHVOrder(int channel, int order) throws DriverException {
        this.ctl.writeRegister(this.baseAddress + 41 + (channel - 1), order);
    }

    public int getHVOrder(int channel) throws DriverException {
        return this.ctl.readRegister(this.baseAddress + 41 + (channel - 1));
    }
}

