/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.drivers.reflex;

import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.drivers.reflex.BoardControl;
import org.lsst.ccs.drivers.reflex.ReflexController;

public class BackplaneControl
extends BoardControl {
    BackplaneControl(ReflexController ctl, ReflexController.BoardSlot slot) {
        super(ctl, slot);
    }

    @Override
    public ReflexController.BoardType getBoardType() {
        return ReflexController.BoardType.BACKPLANE_X6;
    }

    public void setMasterClock(int hz) throws DriverException {
        this.ctl.writeRegister(this.baseAddress, hz);
    }

    public int getMasterClock() throws DriverException {
        return this.ctl.readRegister(this.baseAddress);
    }

    public void setDaughterEnable(int bitfield) throws DriverException {
        this.ctl.writeRegister(this.baseAddress + 1, bitfield);
    }

    public int getDaughterEnable() throws DriverException {
        return this.ctl.readRegister(this.baseAddress + 1);
    }

    public void setPairCount(int pc) throws DriverException {
        this.ctl.writeRegister(this.baseAddress + 2, pc);
    }

    public int getPairCount() throws DriverException {
        return this.ctl.readRegister(this.baseAddress + 2);
    }

    public void setPairChannelDaughterModule(int pairnum, int ab, int bitfield) throws DriverException {
        this.ctl.writeRegister(this.baseAddress + 3 + pairnum + ab * 4, bitfield);
    }

    public int getPairChannelDaughterModule(int pairnum, int ab) throws DriverException {
        return this.ctl.readRegister(this.baseAddress + 3 + pairnum + ab * 4);
    }

    public void setPixelClock(int pc) throws DriverException {
        this.ctl.writeRegister(this.baseAddress + 11, pc);
    }

    public int getPixelClock() throws DriverException {
        return this.ctl.readRegister(this.baseAddress + 11);
    }

    public void setTriggering(int t) throws DriverException {
        this.ctl.writeRegister(this.baseAddress + 12, t);
    }

    public int getTriggering() throws DriverException {
        return this.ctl.readRegister(this.baseAddress + 12);
    }
}

