/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.drivers.reflex;

import java.io.Serializable;
import org.lsst.ccs.drivers.reflex.ReflexController;
import org.lsst.ccs.utilities.logging.Logger;

public class ReflexStatus
implements Serializable {
    private static final long serialVersionUID = 3374708539867878786L;
    int errorCode;
    int errorSource;
    int errorLine;
    int statusIndex;
    int powerState;
    int[] boardTypes = new int[12];
    int[] romID = new int[12];
    int[] buildNumber = new int[12];
    int[] featureFlags = new int[12];
    Logger log = Logger.getLogger((String)"org.lsst.reflex");
    BoardStatus[] boardStatus = new BoardStatus[12];

    public ReflexController.BoardType getBoardType(int i) {
        int tt = this.boardTypes[i] >> 24;
        return ReflexController.BoardType.forType(tt);
    }

    public String getBoardRevision(int i) {
        int rr = (this.boardTypes[i] & 0xFF0000) >> 16;
        int mm = (this.boardTypes[i] & 0xFF00) >> 8;
        int nn = this.boardTypes[i] & 0xFF;
        char c = Character.toChars(65 + rr)[0];
        return String.format("%c %d.%d.%d", Character.valueOf(c), mm, nn, this.buildNumber[i]);
    }

    int[] findBoards(ReflexController.BoardType t) {
        int[] bn = new int[12];
        int n = 0;
        int i = 0;
        while (i < 12) {
            if (this.getBoardType(i) == t) {
                bn[n++] = i;
            }
            ++i;
        }
        int[] b = new int[n];
        System.arraycopy(bn, 0, b, 0, n);
        return b;
    }

    public void checkRevisions() {
        int pbindex;
        int pbRev;
        int interfaceBuild;
        int backplaneRev = (this.boardTypes[0] & 0xFF0000) >> 16;
        if (backplaneRev == 0) {
            this.log.fatal((Object)"FATAL ERROR cannot handle Backplane revision A", new String[0]);
            System.exit(-1);
        }
        if (backplaneRev != 2) {
            this.log.warn((Object)("Non nominal backplane revision, only Rev C tested :" + this.getBoardRevision(0)), new String[0]);
        }
        if ((interfaceBuild = this.buildNumber[1]) <= 430) {
            this.log.fatal((Object)("FATAL ERROR cannot handle interface build <= 430 : " + interfaceBuild), new String[0]);
            System.exit(-1);
        }
        if (interfaceBuild != 455) {
            this.log.warn((Object)("Non nominal interface build, only build 455 tested :" + this.getBoardRevision(1)), new String[0]);
        }
        if ((pbRev = (this.boardTypes[pbindex = this.findBoards(ReflexController.BoardType.POWERB)[0]] & 0xFF0000) >> 16) < 4) {
            this.log.fatal((Object)"FATAL ERROR cannot handle POWER B revisions lower than E", new String[0]);
            System.exit(-1);
        }
        if (pbRev != 4) {
            this.log.warn((Object)("Non nominal POWER B revision, only Rev E tested :" + this.getBoardRevision(pbindex)), new String[0]);
        }
    }

    public void dump() {
        System.out.printf("error code %s\n", this.errorCode);
        System.out.printf("error source %s\n", this.errorSource);
        System.out.printf("error line %s\n", this.errorLine);
        System.out.printf("status index %s\n", this.statusIndex);
        System.out.printf("power state %s\n", this.powerState);
        int i = 0;
        while (i < 12) {
            System.out.printf("\n*** board %d type %s Rev. %s\n", new Object[]{i, this.getBoardType(i), this.getBoardRevision(i)});
            BoardStatus bs = this.boardStatus[i];
            if (bs != null) {
                bs.dump();
            }
            ++i;
        }
    }

    public ReflexController.BoardType[] getBoardTypes() {
        ReflexController.BoardType[] tt = new ReflexController.BoardType[13];
        int i = 0;
        while (i < 13) {
            int t = this.boardTypes[i] >> 24;
            tt[i] = ReflexController.BoardType.forType(t);
            ++i;
        }
        return tt;
    }

    public static class AD8X100Status
    extends BoardStatus {
        private static final long serialVersionUID = 5811084942281260759L;
        int status;

        @Override
        public void dump() {
            super.dump();
            System.out.printf("status %08X\n", this.status);
        }
    }

    public static class AD8X120Status
    extends BoardStatus {
        private static final long serialVersionUID = -3168912407885345768L;
        int status;

        @Override
        public void dump() {
            super.dump();
            System.out.printf("status %08X\n", this.status);
        }
    }

    public static class BackplaneStatus
    extends BoardStatus {
        private static final long serialVersionUID = 3362594551204925405L;
        int status;

        @Override
        public void dump() {
            super.dump();
            System.out.printf("status %08X\n", this.status);
        }
    }

    public static class BiasStatus
    extends BoardStatus {
        private static final long serialVersionUID = 7837103979251692628L;
        int status;
        int[] lv = new int[8];
        int[] hv = new int[8];
        int[] lc = new int[8];
        int[] hc = new int[8];

        @Override
        public void dump() {
            super.dump();
            System.out.printf("status %08X\n", this.status);
            int i = 0;
            while (i < 8) {
                System.out.printf("LV%d %7.3f %7.3f    HV%d %7.3f %7.3f\n", i + 1, (double)this.lv[i] / 1000.0, (double)this.lc[i] / 1000.0, i + 1, (double)this.hv[i] / 1000.0, (double)this.hc[i] / 1000.0);
                ++i;
            }
        }
    }

    public static class BoardStatus
    implements Serializable {
        private static final long serialVersionUID = -2316945244308302886L;
        int temperature;

        public void dump() {
            System.out.printf("temperature %2.3f\n", (double)(this.temperature - 273150) / 1000.0);
        }
    }

    public static class DriverStatus
    extends BoardStatus {
        private static final long serialVersionUID = 3602032819063285937L;
        int status;

        @Override
        public void dump() {
            super.dump();
            System.out.printf("status %08X\n", this.status);
        }
    }

    public static class InterfaceStatus
    extends BoardStatus {
        private static final long serialVersionUID = 3389851569787973971L;
    }

    public static class PowerAStatus
    extends BoardStatus {
        private static final long serialVersionUID = -7218331917285754309L;
        int V5VD;
        int I5VD;
        int V5VA;
        int I5VA;
        int Vm5V;
        int Im5V;

        @Override
        public void dump() {
            super.dump();
            System.out.printf("+5VD  %7.3f %7.3f\n", (double)this.V5VD / 1000.0, (double)this.I5VD / 1000.0);
            System.out.printf("+5VA  %7.3f %7.3f\n", (double)this.V5VA / 1000.0, (double)this.I5VA / 1000.0);
            System.out.printf("-5V   %7.3f %7.3f\n", (double)this.Vm5V / 1000.0, (double)this.Im5V / 1000.0);
        }
    }

    public static class PowerBStatus
    extends BoardStatus {
        private static final long serialVersionUID = -2936950124927843267L;
        int V30V;
        int I30V;
        int V15V;
        int I15V;
        int Vm15V;
        int Im15V;
        int TECSetPoint;
        int TECActual;

        @Override
        public void dump() {
            super.dump();
            System.out.printf("+30V  %7.3f %7.3f\n", (double)this.V30V / 1000.0, (double)this.I30V / 1000.0);
            System.out.printf("+15V  %7.3f %7.3f\n", (double)this.V15V / 1000.0, (double)this.I15V / 1000.0);
            System.out.printf("-15V  %7.3f %7.3f\n", (double)this.Vm15V / 1000.0, (double)this.Im15V / 1000.0);
            System.out.printf("TEC   %7.3f %7.3f\n", (double)(this.TECSetPoint - 273150) / 1000.0, (double)(this.TECActual - 273150) / 1000.0);
        }
    }
}

