/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.drivers.reflex;

import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.drivers.reflex.BoardControl;
import org.lsst.ccs.drivers.reflex.ReflexController;

public class InterfaceControl
extends BoardControl {
    InterfaceControl(ReflexController ctl, ReflexController.BoardSlot slot) {
        super(ctl, slot);
    }

    @Override
    public ReflexController.BoardType getBoardType() {
        return ReflexController.BoardType.CAMERALINK;
    }

    public void setTapCount(int tapcount) throws DriverException {
        this.ctl.writeRegister(this.baseAddress, tapcount);
    }

    public int getTapCount() throws DriverException {
        return this.ctl.readRegister(this.baseAddress);
    }

    public void setLoopCount(int loopcount) throws DriverException {
        this.ctl.writeRegister(this.baseAddress + 1, loopcount);
    }

    public int getLoopCount() throws DriverException {
        return this.ctl.readRegister(this.baseAddress + 1);
    }

    public void setTapEnable(int ab, int tapbitfield) throws DriverException {
        this.ctl.writeRegister(this.baseAddress + 2 + ab, tapbitfield);
    }

    public int getTapEnable(int ab) throws DriverException {
        return this.ctl.readRegister(this.baseAddress + 2 + ab);
    }

    public void setTapStart(int ab, int tap, int startAddress) throws DriverException {
        this.ctl.writeRegister(this.baseAddress + 4 + ab * 32 + tap, startAddress);
    }

    public int getTapStart(int ab, int tap) throws DriverException {
        return this.ctl.readRegister(this.baseAddress + 4 + ab * 32 + tap);
    }

    public void setTapDelta(int ab, int tap, int deltaAddress) throws DriverException {
        this.ctl.writeRegister(this.baseAddress + 68 + ab * 32 + tap, deltaAddress);
    }

    public int getTapDelta(int ab, int tap) throws DriverException {
        return this.ctl.readRegister(this.baseAddress + 68 + ab * 32 + tap);
    }

    public void setLineLength(int lineLength) throws DriverException {
        this.ctl.writeRegister(this.baseAddress + 132, lineLength);
    }

    public int getLineLength() throws DriverException {
        return this.ctl.readRegister(this.baseAddress + 132);
    }

    public void setPrecount(int postcount) throws DriverException {
        this.ctl.writeRegister(this.baseAddress + 133, postcount);
    }

    public int getPrecount() throws DriverException {
        return this.ctl.readRegister(this.baseAddress + 133);
    }

    public void setPostcount(int postcount) throws DriverException {
        this.ctl.writeRegister(this.baseAddress + 134, postcount);
    }

    public int getPostcount() throws DriverException {
        return this.ctl.readRegister(this.baseAddress + 134);
    }

    public void setLinecount(int linecount) throws DriverException {
        this.ctl.writeRegister(this.baseAddress + 135, linecount);
    }

    public int getLinecount() throws DriverException {
        return this.ctl.readRegister(this.baseAddress + 135);
    }

    public void setIdlecount(int idlecount) throws DriverException {
        this.ctl.writeRegister(this.baseAddress + 136, idlecount);
    }

    public int getIdlecount() throws DriverException {
        return this.ctl.readRegister(this.baseAddress + 136);
    }

    public void setCameraLinkMode(int full_or_base) throws DriverException {
        this.ctl.writeRegister(this.baseAddress + 137, full_or_base);
    }

    public int getCameraLinkMode() throws DriverException {
        return this.ctl.readRegister(this.baseAddress + 137);
    }

    public void setCameraSpeed(int speed) throws DriverException {
        this.ctl.writeRegister(this.baseAddress + 138, speed);
    }

    public int getCameraSpeed() throws DriverException {
        return this.ctl.readRegister(this.baseAddress + 138);
    }
}

