/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.drivers.reflex;

import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.drivers.reflex.BoardControl;
import org.lsst.ccs.drivers.reflex.ReflexController;

public class DriverControl
extends BoardControl {
    DriverControl(ReflexController ctl, ReflexController.BoardSlot slot) {
        super(ctl, slot);
    }

    @Override
    public ReflexController.BoardType getBoardType() {
        return ReflexController.BoardType.DRIVER;
    }

    public void setDriverEnable(int bitfield) throws DriverException {
        this.ctl.writeRegister(this.baseAddress, bitfield);
    }

    public int getDriverEnable() throws DriverException {
        return this.ctl.readRegister(this.baseAddress);
    }

    public void setChannelLow(int channel, int low) throws DriverException {
        this.ctl.writeRegister(this.baseAddress + 1 + (channel - 1) * 3, low);
    }

    public void setChannelHigh(int channel, int high) throws DriverException {
        this.ctl.writeRegister(this.baseAddress + 2 + (channel - 1) * 3, high);
    }

    public void setChannelSlew(int channel, int slew) throws DriverException {
        this.ctl.writeRegister(this.baseAddress + 3 + (channel - 1) * 3, slew);
    }

    public int getChannelLow(int channel) throws DriverException {
        return this.ctl.readRegister(this.baseAddress + 1 + (channel - 1) * 3);
    }

    public int getChannelHigh(int channel) throws DriverException {
        return this.ctl.readRegister(this.baseAddress + 2 + (channel - 1) * 3);
    }

    public int getChannelSlew(int channel) throws DriverException {
        return this.ctl.readRegister(this.baseAddress + 3 + (channel - 1) * 3);
    }

    public void setChannelA(int channel, int low) throws DriverException {
        this.ctl.writeRegister(this.baseAddress + 37 + (channel - 1) * 2, low);
    }

    public void setChannelB(int channel, int high) throws DriverException {
        this.ctl.writeRegister(this.baseAddress + 38 + (channel - 1) * 2, high);
    }

    public int getChannelA(int channel) throws DriverException {
        return this.ctl.readRegister(this.baseAddress + 37 + (channel - 1) * 2);
    }

    public int getChannelB(int channel) throws DriverException {
        return this.ctl.readRegister(this.baseAddress + 38 + (channel - 1) * 2);
    }
}

