package org.lsst.ccs.drivers.reflex;

import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.drivers.reflex.ReflexController.BoardSlot;
import org.lsst.ccs.drivers.reflex.ReflexController.BoardType;

public class SystemControl extends BoardControl {

    SystemControl(ReflexController ctl, BoardSlot slot) {
        super(ctl, slot);
        baseAddress = 0x10000000;
    }

    @Override
    public BoardType getBoardType() {
        return BoardType.SYSTEM;
    }

    public void setTimingLines(int lines) throws DriverException {
        ctl.writeRegister(baseAddress, lines);
    }

    public int getTimingLines() throws DriverException {
        return ctl.readRegister(baseAddress);
    }

    /* 0..63 */
    public void setTimingParameter(int n, int value) throws DriverException {
        ctl.writeRegister(baseAddress + n + 1, value);
    }

    public int getTimingParameter(int n) throws DriverException {
        return ctl.readRegister(baseAddress + n + 1);
    }

}
