package org.lsst.ccs.drivers.reflex;

import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.drivers.reflex.ReflexController.BoardSlot;
import org.lsst.ccs.drivers.reflex.ReflexController.BoardType;

public class PowerBControl extends BoardControl {

    PowerBControl(ReflexController ctl, BoardSlot slot) {
        super(ctl, slot);
    }

    @Override
    public BoardType getBoardType() {
        return BoardType.POWERB;
    }

    public void setTECSetPoint(int x) throws DriverException {
        ctl.writeRegister(baseAddress, x);
    }

    public int getTECSetPoint() throws DriverException {
        return ctl.readRegister(baseAddress);
    }

    // undocumented
    // POWERB_TEMPA_CONTROL 0x01
    // POWERB_TEMPB_CONTROL 0x02
    // POWERB_TEMPA_TARGET 0x03
    // POWERB_TEMPB_TARGET 0x04
    // POWERB_TEMPA_P 0x05
    // POWERB_TEMPB_P 0x06
    // POWERB_TEMPA_I 0x07
    // POWERB_TEMPB_I 0x08
    // POWERB_TEMPA_D 0x09
    // POWERB_TEMPB_D 0x0A
    // POWERB_TEMPA_FORCE 0x0B
    // POWERB_TEMPB_FORCE 0x0C

    public void setTempControl(int ab, int x) throws DriverException {
        ctl.writeRegister(baseAddress + 1 + ab, x);
    }

    public void setTempTarget(int ab, int x) throws DriverException {
        ctl.writeRegister(baseAddress + 3 + ab, x);
    }

    public void setTempP(int ab, int x) throws DriverException {
        ctl.writeRegister(baseAddress + 5 + ab, x);
    }

    public void setTempI(int ab, int x) throws DriverException {
        ctl.writeRegister(baseAddress + 7 + ab, x);
    }

    public void setTempD(int ab, int x) throws DriverException {
        ctl.writeRegister(baseAddress + 9 + ab, x);
    }

    public void setTempForce(int ab, int x) throws DriverException {
        ctl.writeRegister(baseAddress + 0x0B + ab, x);
    }

    public int getTempControl(int ab) throws DriverException {
        return ctl.readRegister(baseAddress + 1 + ab);
    }

    public int getTempTarget(int ab) throws DriverException {
        return ctl.readRegister(baseAddress + 3 + ab);
    }

    public int getTempP(int ab) throws DriverException {
        return ctl.readRegister(baseAddress + 5 + ab);
    }

    public int getTempI(int ab) throws DriverException {
        return ctl.readRegister(baseAddress + 7 + ab);
    }

    public int getTempD(int ab) throws DriverException {
        return ctl.readRegister(baseAddress + 9 + ab);
    }

    public int getTempForce(int ab) throws DriverException {
        return ctl.readRegister(baseAddress + 0x0B + ab);
    }

}
