package org.lsst.ccs.drivers.reflex;

import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.drivers.reflex.ReflexController.BoardSlot;
import org.lsst.ccs.drivers.reflex.ReflexController.BoardType;

public class InterfaceControl extends BoardControl {

    InterfaceControl(ReflexController ctl, BoardSlot slot) {
        super(ctl, slot);
    }

    @Override
    public BoardType getBoardType() {
        return BoardType.CAMERALINK;
    }

    public void setTapCount(int tapcount) throws DriverException {
        ctl.writeRegister(baseAddress, tapcount);
    }

    public int getTapCount() throws DriverException {
        return ctl.readRegister(baseAddress);
    }

    public void setLoopCount(int loopcount) throws DriverException {
        ctl.writeRegister(baseAddress + 1, loopcount);
    }

    public int getLoopCount() throws DriverException {
        return ctl.readRegister(baseAddress + 1);
    }

    public void setTapEnable(int ab, int tapbitfield) throws DriverException {
        ctl.writeRegister(baseAddress + 2 + ab, tapbitfield);
    }

    public int getTapEnable(int ab) throws DriverException {
        return ctl.readRegister(baseAddress + 2 + ab);
    }

    /* tap 0..31 */
    public void setTapStart(int ab, int tap, int startAddress)
            throws DriverException {
        ctl.writeRegister(baseAddress + 4 + ab * 32 + tap, startAddress);
    }

    public int getTapStart(int ab, int tap) throws DriverException {
        return ctl.readRegister(baseAddress + 4 + ab * 32 + tap);
    }

    public void setTapDelta(int ab, int tap, int deltaAddress)
            throws DriverException {
        ctl.writeRegister(baseAddress + 0x44 + ab * 32 + tap, deltaAddress);
    }

    public int getTapDelta(int ab, int tap) throws DriverException {
        return ctl.readRegister(baseAddress + 0x44 + ab * 32 + tap);
    }

    public void setLineLength(int lineLength) throws DriverException {
        ctl.writeRegister(baseAddress + 0x84, lineLength);
    }

    public int getLineLength() throws DriverException {
        return ctl.readRegister(baseAddress + 0x84);
    }

    public void setPrecount(int postcount) throws DriverException {
        ctl.writeRegister(baseAddress + 0x85, postcount);
    }

    public int getPrecount() throws DriverException {
        return ctl.readRegister(baseAddress + 0x85);
    }

    public void setPostcount(int postcount) throws DriverException {
        ctl.writeRegister(baseAddress + 0x86, postcount);
    }

    public int getPostcount() throws DriverException {
        return ctl.readRegister(baseAddress + 0x86);
    }

    public void setLinecount(int linecount) throws DriverException {
        ctl.writeRegister(baseAddress + 0x87, linecount);
    }

    public int getLinecount() throws DriverException {
        return ctl.readRegister(baseAddress + 0x87);
    }

    public void setIdlecount(int idlecount) throws DriverException {
        ctl.writeRegister(baseAddress + 0x88, idlecount);
    }

    public int getIdlecount() throws DriverException {
        return ctl.readRegister(baseAddress + 0x88);
    }

    public void setCameraLinkMode(int full_or_base) throws DriverException {
        ctl.writeRegister(baseAddress + 0x89, full_or_base);
    }

    public int getCameraLinkMode() throws DriverException {
        return ctl.readRegister(baseAddress + 0x89);
    }

    // CL REV C and up seem to have (undocumented)
    // CL_SPEED at 0x8A

    public void setCameraSpeed(int speed) throws DriverException {
        ctl.writeRegister(baseAddress + 0x8A, speed);
    }

    public int getCameraSpeed() throws DriverException {
        return ctl.readRegister(baseAddress + 0x8A);
    }

}
