package org.lsst.ccs.drivers.reflex;

import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.drivers.reflex.ReflexController.BoardSlot;
import org.lsst.ccs.drivers.reflex.ReflexController.BoardType;

public class DriverControl extends BoardControl {

    DriverControl(ReflexController ctl, BoardSlot slot) {
        super(ctl, slot);
    }

    @Override
    public BoardType getBoardType() {
        return BoardType.DRIVER;
    }

    public void setDriverEnable(int bitfield) throws DriverException {
        ctl.writeRegister(baseAddress, bitfield);
    }

    public int getDriverEnable() throws DriverException {
        return ctl.readRegister(baseAddress);
    }

    /* channel : 1-12 */
    public void setChannelLow(int channel, int low) throws DriverException {
        ctl.writeRegister(baseAddress + 1 + (channel - 1) * 3, low);
    }

    public void setChannelHigh(int channel, int high) throws DriverException {
        ctl.writeRegister(baseAddress + 2 + (channel - 1) * 3, high);
    }

    public void setChannelSlew(int channel, int slew) throws DriverException {
        ctl.writeRegister(baseAddress + 3 + (channel - 1) * 3, slew);
    }

    public int getChannelLow(int channel) throws DriverException {
        return ctl.readRegister(baseAddress + 1 + (channel - 1) * 3);
    }

    public int getChannelHigh(int channel) throws DriverException {
        return ctl.readRegister(baseAddress + 2 + (channel - 1) * 3);
    }

    public int getChannelSlew(int channel) throws DriverException {
        return ctl.readRegister(baseAddress + 3 + (channel - 1) * 3);
    }

    // undocumented :
    // ChannelA at 0x25, 0x27, 0x29 etc
    // ChannelB at 0x26, 0x28, 0x2A etc

    public void setChannelA(int channel, int low) throws DriverException {
        ctl.writeRegister(baseAddress + 0x25 + (channel - 1) * 2, low);
    }

    public void setChannelB(int channel, int high) throws DriverException {
        ctl.writeRegister(baseAddress + 0x26 + (channel - 1) * 2, high);
    }

    public int getChannelA(int channel) throws DriverException {
        return ctl.readRegister(baseAddress + 0x25 + (channel - 1) * 2);
    }

    public int getChannelB(int channel) throws DriverException {
        return ctl.readRegister(baseAddress + 0x26 + (channel - 1) * 2);
    }

}
