package org.lsst.ccs.drivers.reflex;

import org.lsst.ccs.drivers.reflex.ReflexController.BoardSlot;
import org.lsst.ccs.drivers.reflex.ReflexController.BoardType;

public abstract class BoardControl {

    BoardControl(ReflexController ctl, BoardSlot slot) {
        this.ctl = ctl;
        this.slot = slot;
        baseAddress = 0x10000000 + ((slot.num + 1) << 16);
    }

    ReflexController ctl;
    BoardSlot slot;
    int baseAddress;

    public abstract BoardType getBoardType();

    public BoardSlot getBoardSlot() {
        return slot;

    }
}
