package org.lsst.ccs.drivers.reflex;

import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.drivers.reflex.ReflexController.BoardSlot;
import org.lsst.ccs.drivers.reflex.ReflexController.BoardType;

public class BiasControl extends BoardControl {

    BiasControl(ReflexController ctl, BoardSlot slot) {
        super(ctl, slot);
    }

    @Override
    public BoardType getBoardType() {
        return BoardType.DRIVER;
    }

    // 0x01-0x80 : LV1-8 ; 0x100-0x8000 : HV1-8
    public void setBiasEnable(int bitfield) throws DriverException {
        ctl.writeRegister(baseAddress, bitfield);
    }

    public int getBiasEnable() throws DriverException {
        return ctl.readRegister(baseAddress);
    }

    // channel 1-8
    public void setLVVoltage(int channel, int v) throws DriverException {
        ctl.writeRegister(baseAddress + 0x01 + (channel - 1), v);
    }

    public int getLVVoltage(int channel) throws DriverException {
        return ctl.readRegister(baseAddress + 0x01 + (channel - 1));
    }

    public void setHVVoltage(int channel, int v) throws DriverException {
        ctl.writeRegister(baseAddress + 0x09 + (channel - 1), v);
    }

    public int getHVVoltage(int channel) throws DriverException {
        return ctl.readRegister(baseAddress + 0x09 + (channel - 1));
    }

    public void setLVCurrent(int channel, int v) throws DriverException {
        ctl.writeRegister(baseAddress + 0x11 + (channel - 1), v);
    }

    public int getLVCurrent(int channel) throws DriverException {
        return ctl.readRegister(baseAddress + 0x11 + (channel - 1));
    }

    public void setHVCurrent(int channel, int v) throws DriverException {
        ctl.writeRegister(baseAddress + 0x19 + (channel - 1), v);
    }

    public int getHVCurrent(int channel) throws DriverException {
        return ctl.readRegister(baseAddress + 0x19 + (channel - 1));
    }

    // undocumented
    // ORDER LVi starting at 0x21
    // ORDER HVi starting at 0x29

    public void setLVOrder(int channel, int order) throws DriverException {
        ctl.writeRegister(baseAddress + 0x21 + (channel - 1), order);
    }

    public int getLVOrder(int channel) throws DriverException {
        return ctl.readRegister(baseAddress + 0x21 + (channel - 1));
    }

    public void setHVOrder(int channel, int order) throws DriverException {
        ctl.writeRegister(baseAddress + 0x29 + (channel - 1), order);
    }

    public int getHVOrder(int channel) throws DriverException {
        return ctl.readRegister(baseAddress + 0x29 + (channel - 1));
    }

}
