package org.lsst.ccs.drivers.reflex;

import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.drivers.reflex.ReflexController.BoardSlot;
import org.lsst.ccs.drivers.reflex.ReflexController.BoardType;

public class BackplaneControl extends BoardControl {

    BackplaneControl(ReflexController ctl, BoardSlot slot) {
        super(ctl, slot);
    }

    @Override
    public BoardType getBoardType() {
        return BoardType.BACKPLANE_X6;
    }

    public void setMasterClock(int hz) throws DriverException {
        ctl.writeRegister(baseAddress, hz);
    }

    public int getMasterClock() throws DriverException {
        return ctl.readRegister(baseAddress);
    }

    public void setDaughterEnable(int bitfield) throws DriverException {
        ctl.writeRegister(baseAddress + 1, bitfield);
    }

    public int getDaughterEnable() throws DriverException {
        return ctl.readRegister(baseAddress + 1);
    }

    public void setPairCount(int pc) throws DriverException {
        ctl.writeRegister(baseAddress + 2, pc);
    }

    public int getPairCount() throws DriverException {
        return ctl.readRegister(baseAddress + 2);
    }

    // Pair 1 Channel A : pairnum=1, ab=0
    // documentation is inconsistent with driver
    // BACKPLANE_REVB_TAPA_SOURCE0 3
    // BACKPLANE_REVB_TAPA_SOURCE1 4
    // BACKPLANE_REVB_TAPA_SOURCE2 5
    // BACKPLANE_REVB_TAPA_SOURCE3 6
    // BACKPLANE_REVB_TAPB_SOURCE0 7
    // BACKPLANE_REVB_TAPB_SOURCE1 8
    // BACKPLANE_REVB_TAPB_SOURCE2 9
    // BACKPLANE_REVB_TAPB_SOURCE3 A

    /* pairnum 0..3 */
    public void setPairChannelDaughterModule(int pairnum, int ab, int bitfield)
            throws DriverException {
        // ctl.writeRegister(baseAddress + 3 + pairnum * 2 + ab, bitfield); //
        // documentation
        ctl.writeRegister(baseAddress + 3 + pairnum + ab * 4, bitfield);
    }

    public int getPairChannelDaughterModule(int pairnum, int ab)
            throws DriverException {
        // return ctl.readRegister(baseAddress + 3 + pairnum * 2 + ab);
        return ctl.readRegister(baseAddress + 3 + pairnum + ab * 4);
    }

    // BACKPLANE REV B and up seems to have (undocumented)
    // PCLK at 0x0B
    // TRIGGING at 0x0C

    public void setPixelClock(int pc) throws DriverException {
        ctl.writeRegister(baseAddress + 0x0B, pc);
    }

    public int getPixelClock() throws DriverException {
        return ctl.readRegister(baseAddress + 0x0B);
    }

    public void setTriggering(int t) throws DriverException {
        ctl.writeRegister(baseAddress + 0x0C, t);
    }

    public int getTriggering() throws DriverException {
        return ctl.readRegister(baseAddress + 0x0C);
    }

}
