package org.lsst.ccs.drivers.reflex;

import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.drivers.reflex.ReflexController.BoardSlot;
import org.lsst.ccs.drivers.reflex.ReflexController.BoardType;

public class AD8X100Control extends BoardControl {

    AD8X100Control(ReflexController ctl, BoardSlot slot) {
        super(ctl, slot);
    }

    @Override
    public BoardType getBoardType() {
        return BoardType.AD8X100;
    }

    public void setClampLow(int x) throws DriverException {
        ctl.writeRegister(baseAddress, x);
    }

    public int getClampLow() throws DriverException {
        return ctl.readRegister(baseAddress);
    }

    public void setClampHigh(int x) throws DriverException {
        ctl.writeRegister(baseAddress + 1, x);
    }

    public int getClampHigh() throws DriverException {
        return ctl.readRegister(baseAddress + 1);
    }

    public void setRawMode(int x) throws DriverException {
        ctl.writeRegister(baseAddress + 2, x);
    }

    public int getRawMode() throws DriverException {
        return ctl.readRegister(baseAddress + 2);
    }

    public void setRawChannel(int x) throws DriverException {
        ctl.writeRegister(baseAddress + 3, x);
    }

    public int getRawChannel() throws DriverException {
        return ctl.readRegister(baseAddress + 3);
    }

    public void setCDSGain(int x) throws DriverException { // 1.0 = 0x000100000
        ctl.writeRegister(baseAddress + 4, x);
    }

    public int getCDSGain() throws DriverException {
        return ctl.readRegister(baseAddress + 4);
    }

    public void setCDSOffset(int x) throws DriverException {
        ctl.writeRegister(baseAddress + 5, x);
    }

    public int getCDSOffset() throws DriverException {
        return ctl.readRegister(baseAddress + 5);
    }

    public void setHDRMode(int x) throws DriverException {
        ctl.writeRegister(baseAddress + 6, x);
    }

    public int getHDRMode() throws DriverException {
        return ctl.readRegister(baseAddress + 6);
    }

    public void setCDSResetStart(int x) throws DriverException {
        ctl.writeRegister(baseAddress + 7, x);
    }

    public int getCDSResetStart() throws DriverException {
        return ctl.readRegister(baseAddress + 7);
    }

    public void setCDSResetStop(int x) throws DriverException {
        ctl.writeRegister(baseAddress + 8, x);
    }

    public int getCDSResetStop() throws DriverException {
        return ctl.readRegister(baseAddress + 8);
    }

    public void setCDSVideoStart(int x) throws DriverException {
        ctl.writeRegister(baseAddress + 9, x);
    }

    public int getCDSVideoStart() throws DriverException {
        return ctl.readRegister(baseAddress + 9);
    }

    public void setCDSVideoStop(int x) throws DriverException {
        ctl.writeRegister(baseAddress + 0xA, x);
    }

    public int getCDSVideoStop() throws DriverException {
        return ctl.readRegister(baseAddress + 0xA);
    }

}
