/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.drivers.reflex;

import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.drivers.reflex.BoardControl;
import org.lsst.ccs.drivers.reflex.ReflexController;

public class SystemControl
extends BoardControl {
    SystemControl(ReflexController ctl, ReflexController.BoardSlot slot) {
        super(ctl, slot);
        this.baseAddress = 0x10000000;
    }

    @Override
    public ReflexController.BoardType getBoardType() {
        return ReflexController.BoardType.SYSTEM;
    }

    public void setTimingLines(int lines) throws DriverException {
        this.ctl.writeRegister(this.baseAddress, lines);
    }

    public int getTimingLines() throws DriverException {
        return this.ctl.readRegister(this.baseAddress);
    }

    public void setTimingParameter(int n, int value) throws DriverException {
        this.ctl.writeRegister(this.baseAddress + n + 1, value);
    }

    public int getTimingParameter(int n) throws DriverException {
        return this.ctl.readRegister(this.baseAddress + n + 1);
    }
}

