/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.drivers.rebps;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketTimeoutException;
import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.drivers.commons.DriverTimeoutException;
import org.lsst.ccs.utilities.conv.Convert;

public class RebPs {
    public static final int PS_DIGITAL = 0;
    public static final int PS_ANALOG = 1;
    public static final int PS_OD = 2;
    public static final int PS_CLK_HIGH = 3;
    public static final int PS_CLK_LOW = 4;
    public static final int PS_HEATER = 5;
    public static final int PS_DPHI = 5;
    public static final int PS_HV_BIAS = 6;
    public static final int CHAN_VOLT_BEF_LDO = 0;
    public static final int CHAN_CURR_BEF_LDO = 1;
    public static final int CHAN_VOLT_AFT_LDO = 2;
    public static final int CHAN_CURR_AFT_LDO = 3;
    public static final int CHAN_VOLT_AFT_SW = 4;
    public static final int CHAN_VOLT2_AFT_LDO = 5;
    public static final int CHAN_VOLT_DAC = -1;
    public static final int NUM_PS = 7;
    public static final int NUM_REBS = 3;
    private static final int MAX_REGS = 64;
    private static final int READ_TIMEOUT = 1000;
    private static final int DEFAULT_PORT = 8192;
    private static final int PGP_PKT_LENG = 20;
    private static final int PGP_OFF_HEADER = 4;
    private static final int PGP_OFF_OC = 8;
    private static final int PGP_OFF_ADDR = 8;
    private static final int PGP_OFF_DATA = 12;
    private static final int PGP_OFF_FOOTER = 16;
    private static final int PGP_STS_TIMEOUT = 2;
    private static final int PGP_STS_ERROR = 1;
    private static final int DEVC_LTC2945 = 0;
    private static final int DEVC_MAX11644 = 1;
    private static final int DEVC_MAX5803 = 2;
    private static final int REG_FPGA_VERSION = 0;
    private static final int REG_SCRATCH = 1;
    private static final int REG_SERIAL_NO = 2;
    private static final int REG_GEOG_ADDR = 4;
    private static final int REG_SPARE0 = 5;
    private static final int REG_STATUS = 6;
    private static final int REG_STATUS_LATCH = 10;
    private static final int REG_POWER_CTRL = 14;
    private static final int REG_LED_TEST_CTRL = 15;
    private static final int REG_TMO_PS_CFG = 16;
    private static final int REG_TMO_PS_WAIT = 17;
    private static final int REG_TMO_PS_WAIT_0 = 18;
    private static final int REG_TMO_PS_WAIT_1 = 19;
    private static final int REG_TMO_PS_WAIT_3 = 20;
    private static final int REG_TMO_PS_WAIT_5 = 21;
    private static final int REG_TMO_PS_WAIT_2 = 22;
    private static final int REG_TMO_PS_WAIT_6 = 23;
    private static final int REG_TMO_PS_CHECK = 24;
    private static final int REG_TMO_PS_WAIT_DN = 25;
    private static final int REG_PS_STATE_RAFT0 = 26;
    private static final int REG_PS_STATE_RAFT1 = 27;
    private static final int REG_PS_FAIL_RAFT0 = 28;
    private static final int REG_PS_FAIL_RAFT1 = 29;
    private static final int REG_PS_OFF_RAFT0 = 30;
    private static final int REG_PS_OFF_RAFT1 = 31;
    private static final int REG_FAULT_DUMP = 32;
    private static final int REG_DS75LV_WRITE = 224;
    private static final int REG_DS75LV_READ = 225;
    private static final int REG_THRESHOLD = 256;
    private static final int REG_REB_BASE = 65536;
    private static final int REG_REB_INCR = 65536;
    private static final int REG_PS_BASE = 65536;
    private static final int REG_PS_INCR = 4096;
    private static final int REG_DEV_INCR = 256;
    private static final int REG_REB_DATA_BASE = 94208;
    private static final int REG_REB_RDO_PERIOD = 0;
    private static final int REG_REB_RDO_CONFIG = 1;
    private static final int REG_REB_RDO_COUNT = 3;
    private static final int REG_REB_RDO_DIAG_CNT = 4;
    private static final int REG_REB_CHAN_BASE = 94336;
    private static final int XXX = 0;
    private static final byte PGP_OC_READ = 0;
    private static final byte PGP_OC_WRITE = 64;
    private static final int[][] chanOffset = new int[][]{{1, 0, 2, 3, 4}, {9, 8, 10, 11, 12}, {17, 16, 18, 19, 21, 20}, {25, 24, 26, 27, 28}, {33, 32, 34, 35, 37, 36}, {41, 40, 42, 43, 44}, {49, 48, 50}};
    private static final int[][] chanDesc = new int[][]{{1, 0, 2, 16, 17}, {1, 0, 2, 16, 17}, {1, 0, 2, 16, 18, 17}, {1, 0, 2, 16, 17}, {1, 0, 2, 16, 18, 17}, {1, 0, 2, 16, 17, 32}, {1, 0, 16}};
    private static final int[][] devcDesc = new int[][]{{0, 1}, {0, 1}, {0, 0}, {0, 1}, {0, 0}, {0, 1, 2}, {0, 2}};
    private static final int[] dacChannel = new int[]{-1, -1, -1, -1, -1, 5, 2};
    private static final double[][] convConst = new double[][]{{0.025, 4.9E-4, 0.00352, 0.0014, 0.00305}, {0.025, 4.9E-4, 0.00352, 0.0014, 0.00305}, {0.025, 6.41E-5, 0.0206, 6.41E-5, 0.0206, 0.025}, {0.025, 1.25E-4, 0.00654, 6.17E-4, 0.006}, {0.025, 7.58E-4, 0.00352, 5.31E-4, 0.00655, 0.025}, {0.025, 1.25E-4, 0.00654, 7.5E-4, 0.006, 1.0}, {0.025, 2.96E-7, 1.0}};
    private DatagramSocket sock;
    private int seqno;
    private int nSeqErr;
    private int nTimeout;
    private final byte[] inBuff = new byte[272];
    private final byte[] outBuff = new byte[272];
    private final DatagramPacket inPkt = new DatagramPacket(this.inBuff, this.inBuff.length);
    private final DatagramPacket outPkt = new DatagramPacket(this.outBuff, this.outBuff.length);

    public void open(String ipAddr) throws DriverException {
        this.open(ipAddr, 8192);
    }

    public void open(String ipAddr, int port) throws DriverException {
        if (this.sock != null) {
            throw new DriverException("Connection is already open");
        }
        try {
            this.sock = new DatagramSocket();
            InetAddress inetAddr = InetAddress.getByName(ipAddr);
            this.sock.connect(inetAddr, port);
            this.sock.setSoTimeout(1000);
            this.outPkt.setAddress(inetAddr);
            this.outPkt.setPort(port);
            this.nSeqErr = 0;
            this.nTimeout = 0;
        }
        catch (IOException e) {
            throw new DriverException((Throwable)e);
        }
    }

    public void close() throws DriverException {
        this.checkOpen();
        this.sock.close();
        this.sock = null;
    }

    public void writeReg(int addr, int value) throws DriverException {
        this.writeRegs(addr, new int[]{value});
    }

    public synchronized void writeRegs(int addr, int[] value) throws DriverException {
        int j;
        this.checkOpen();
        int count = Math.min(value.length, 64);
        Convert.intToBytesBE((int)addr, (byte[])this.outBuff, (int)8);
        for (j = 0; j < count; ++j) {
            Convert.intToBytesBE((int)value[j], (byte[])this.outBuff, (int)(12 + 4 * j));
        }
        this.outBuff[8] = 64;
        for (j = 0; j < 2; ++j) {
            try {
                this.send(20 + 4 * (count - 1));
                this.receive();
                break;
            }
            catch (DriverTimeoutException e) {
                if (j != 1) continue;
                throw e;
            }
        }
    }

    public int readReg(int addr) throws DriverException {
        return this.readRegs(addr, 1)[0];
    }

    public synchronized int[] readRegs(int addr, int count) throws DriverException {
        this.checkOpen();
        if (count <= 0) {
            return new int[0];
        }
        Convert.intToBytesBE((int)addr, (byte[])this.outBuff, (int)8);
        count = Math.min(count, 64);
        Convert.intToBytesBE((int)(count - 1), (byte[])this.outBuff, (int)12);
        this.outBuff[8] = 0;
        for (int j = 0; j < 2; ++j) {
            try {
                this.send(20);
                this.receive();
                break;
            }
            catch (DriverTimeoutException e) {
                if (j != 1) continue;
                throw e;
            }
        }
        int nRead = (this.inPkt.getLength() - 20) / 4 + 1;
        int[] data = new int[nRead];
        for (int j = 0; j < nRead; ++j) {
            data[j] = Convert.bytesToIntBE((byte[])this.inBuff, (int)(12 + 4 * j));
        }
        return data;
    }

    public synchronized void updateReg(int addr, int mask, int value) throws DriverException {
        this.writeReg(addr, this.readReg(addr) & ~mask | value & mask);
    }

    public int getFwVersion() throws DriverException {
        return this.readReg(0);
    }

    public long getSerialNo() throws DriverException {
        int[] value = this.readRegs(2, 2);
        return (long)value[1] << 32 | (long)value[0] & 0xFFFFFFFFL;
    }

    public int getGeogAddr() throws DriverException {
        return this.readReg(4);
    }

    public void setTemperatureRes(int value) throws DriverException {
        this.writeReg(224, 0x50000 | (value & 3) << 13);
    }

    public double readTemperature() throws DriverException {
        this.writeReg(224, 524288);
        int value = 0;
        for (int count = 0; count < 10; ++count) {
            try {
                Thread.sleep(25L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            value = this.readReg(225);
            if ((value & Integer.MIN_VALUE) != 0) break;
        }
        if ((value & Integer.MIN_VALUE) == 0) {
            throw new DriverException("Timeout reading temperature");
        }
        if ((value & 0x40000000) != 0) {
            throw new DriverException("Error reading temperature");
        }
        return (double)(value & 0xFFFF) / 256.0;
    }

    public void setPower(int rebNum, int value) throws DriverException {
        RebPs.checkRebNumber(rebNum);
        int shift = 8 * (rebNum + 1);
        this.updateReg(5, 255 << shift, value << shift);
        if ((value & 1) != 0) {
            try {
                Thread.sleep(25L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.configure(rebNum);
        }
    }

    public int getPower(int rebNum) throws DriverException {
        RebPs.checkRebNumber(rebNum);
        return this.readReg(5) >> 8 * (rebNum + 1) & 0xFF;
    }

    public int getPowerState() throws DriverException {
        return this.readReg(14) >> 18 & 0x3F;
    }

    public boolean isPowerOn(int rebNum) throws DriverException {
        RebPs.checkRebNumber(rebNum);
        return (this.getPowerState() >> rebNum & 1) != 0;
    }

    public void configure(int rebNum, int psNum, int devc) throws DriverException {
        RebPs.checkRebNumber(rebNum);
        RebPs.checkPsNumber(psNum);
        int addr = RebPs.getDevcBaseAddress(rebNum, psNum, devc);
        switch (RebPs.getDeviceType(psNum, devc)) {
            case 0: {
                break;
            }
            case 1: {
                this.writeReg(addr, 0x3DADADA);
                break;
            }
            case 2: {
                this.writeReg(addr + 38, 0);
            }
        }
    }

    public void configure(int rebNum, int psNum) throws DriverException {
        for (int devc = 0; devc < RebPs.getNumDevices(psNum); ++devc) {
            this.configure(rebNum, psNum, devc);
        }
    }

    public void configure(int rebNum) throws DriverException {
        for (int psNum = 0; psNum < 7; ++psNum) {
            this.configure(rebNum, psNum);
        }
    }

    public double readChannel(int rebNum, int psNum, int chan) throws DriverException {
        double value = this.readChanDirect(rebNum, psNum, chan);
        if (psNum == 4 && (chan == 5 || chan == 4)) {
            double mult = chan == 5 ? 1.0 : 13.1;
            value -= mult * this.readChanDirect(rebNum, psNum, 2);
        }
        return value;
    }

    private double readChanDirect(int rebNum, int psNum, int chan) throws DriverException {
        RebPs.checkRebNumber(rebNum);
        RebPs.checkPsNumber(psNum);
        chan = RebPs.convChannel(psNum, chan);
        int desc = RebPs.getChanDesc(psNum, chan);
        int devc = desc >> 4 & 0xF;
        int dChan = desc & 0xF;
        int addr = RebPs.getDevcBaseAddress(rebNum, psNum, devc);
        int value = 0;
        switch (RebPs.getDeviceType(psNum, devc)) {
            case 0: {
                int[] data = this.readRegs(addr += dChan == 0 ? 20 : (dChan == 1 ? 30 : 40), 2);
                value = (data[0] & 0xFF) << 4 | (data[1] & 0xFF) >> 4;
                break;
            }
            case 1: {
                value = this.readReg(addr) >> 16 * (1 - dChan) & 0xFFF;
                break;
            }
            case 2: {
                value = this.readReg(addr + 160) >> 4 & 0xFFF;
            }
        }
        return (double)value * RebPs.getConversion(psNum, chan);
    }

    public double[] readChannel(int rebNum, int psNum) throws DriverException {
        RebPs.checkRebNumber(rebNum);
        int nChan = RebPs.getNumChannels(psNum);
        double[] values = new double[nChan];
        for (int chan = 0; chan < nChan; ++chan) {
            values[chan] = this.readChannel(rebNum, psNum, chan);
        }
        return values;
    }

    public double readSeqChan(int rebNum, int psNum, int chan) throws DriverException {
        RebPs.checkRebNumber(rebNum);
        RebPs.checkPsNumber(psNum);
        chan = RebPs.convChannel(psNum, chan);
        int addr = RebPs.getSeqChanAddress(rebNum, psNum, chan);
        return (double)this.readReg(addr) * RebPs.getConversion(psNum, chan);
    }

    public void writeDac(int rebNum, int psNum, double value) throws DriverException {
        RebPs.checkRebNumber(rebNum);
        RebPs.checkPsNumber(psNum);
        int chan = RebPs.convChannel(psNum, -1);
        int devc = RebPs.getChanDesc(psNum, chan) >> 4;
        int addr = RebPs.getDevcBaseAddress(rebNum, psNum, devc);
        int val = (int)(value / RebPs.getConversion(psNum, chan));
        this.writeReg(addr + 160, (val & 0xFFF) << 4);
    }

    public static boolean testChannelNumber(int psNum, int chan) throws DriverException {
        return chan >= 0 && chan < RebPs.getNumChannels(psNum);
    }

    public static boolean testRebNumber(int rebNum) throws DriverException {
        return rebNum >= 0 && rebNum < 3;
    }

    public int getNumSeqErr() {
        return this.nSeqErr;
    }

    public int getNumTimeout() {
        return this.nTimeout;
    }

    private static int getNumDevices(int psNum) throws DriverException {
        RebPs.checkPsNumber(psNum);
        return devcDesc[psNum].length;
    }

    private static int getNumChannels(int psNum) throws DriverException {
        RebPs.checkPsNumber(psNum);
        return chanDesc[psNum].length;
    }

    private void checkOpen() throws DriverException {
        if (this.sock == null) {
            throw new DriverException("Connection is not open");
        }
    }

    private void send(int leng) throws DriverException {
        this.seqno += 4;
        Convert.intToBytes((int)this.seqno, (byte[])this.outBuff, (int)4);
        Convert.intToBytes((int)0, (byte[])this.outBuff, (int)(leng - 20 + 16));
        this.outPkt.setLength(leng);
        try {
            this.sock.send(this.outPkt);
        }
        catch (IOException e) {
            throw new DriverException((Throwable)e);
        }
    }

    private void receive() throws DriverException {
        while (true) {
            this.inPkt.setLength(this.inBuff.length);
            try {
                this.sock.receive(this.inPkt);
                int rSeqno = Convert.bytesToInt((byte[])this.inBuff, (int)4);
                if (this.seqno == rSeqno) break;
                ++this.nSeqErr;
            }
            catch (SocketTimeoutException e) {
                ++this.nTimeout;
                throw new DriverTimeoutException();
            }
            catch (IOException e) {
                throw new DriverException((Throwable)e);
            }
        }
        int leng = this.inPkt.getLength();
        int status = Convert.bytesToIntBE((byte[])this.inBuff, (int)(leng + 16 - 20));
        if ((status & 2) != 0) {
            throw new DriverException("Register access timeout");
        }
        if ((status & 1) != 0) {
            throw new DriverException("Register access error");
        }
    }

    private static int convChannel(int psNum, int chan) throws DriverException {
        if (chan == -1) {
            chan = dacChannel[psNum];
        }
        if (chan < 0) {
            throw new DriverException("Power supply has no DAC");
        }
        if (chan >= chanDesc[psNum].length) {
            throw new DriverException("Invalid channel for PS");
        }
        return chan;
    }

    private static int getDeviceType(int psNum, int devc) throws DriverException {
        try {
            return devcDesc[psNum][devc];
        }
        catch (IndexOutOfBoundsException e) {
            throw new DriverException("Invalid device index for PS");
        }
    }

    private static int getChanDesc(int psNum, int chan) throws DriverException {
        return chanDesc[psNum][chan];
    }

    private static int getDevcBaseAddress(int rebNum, int psNum, int devc) throws DriverException {
        return 65536 + 65536 * rebNum + 4096 * psNum + 256 * devc;
    }

    private static int getSeqChanAddress(int rebNum, int psNum, int chan) throws DriverException {
        return 94336 + 65536 * rebNum + chanOffset[psNum][chan];
    }

    private static double getConversion(int psNum, int chan) throws DriverException {
        return convConst[psNum][chan];
    }

    private static void checkRebNumber(int rebNum) throws DriverException {
        if (!RebPs.testRebNumber(rebNum)) {
            throw new DriverException("Invalid REB number (" + rebNum + ")");
        }
    }

    private static void checkPsNumber(int psNum) throws DriverException {
        if (psNum < 0 || psNum >= 7) {
            throw new DriverException("Invalid PS number (" + psNum + ")");
        }
    }
}

