/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.utilities.scheduler;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Delayed;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import org.lsst.ccs.utilities.scheduler.Scheduler;

public class PeriodicTask
implements Runnable,
ScheduledFuture<Void> {
    private static final SuspendedTask STOPPED = new SuspendedTask();
    private final Scheduler scheduler;
    private final Runnable runner;
    private final boolean isFixedRate;
    private final String name;
    private final Level level;
    private volatile ScheduledFuture<?> delegate;
    private long period;
    private boolean isStopped;
    private int failures;
    private volatile int maxFailures;
    private final CountDownLatch cancelLatch = new CountDownLatch(1);

    public PeriodicTask(Scheduler scheduler, Runnable runnable, boolean isFixedRate, String taskName, Level logLevel, long period, TimeUnit unit) {
        if (scheduler == null || runnable == null) {
            throw new NullPointerException();
        }
        this.scheduler = scheduler;
        this.runner = runnable;
        this.isFixedRate = isFixedRate;
        this.name = taskName == null ? "" : taskName;
        this.level = logLevel == null ? scheduler.getDefaultLogLevel() : logLevel;
        this.period = period > 0L ? unit.toNanos(period) : 0L;
        this.isStopped = true;
        this.delegate = STOPPED;
        this.maxFailures = scheduler.maxFailures;
    }

    @Override
    public void run() {
        block16: {
            try {
                try {
                    Thread.currentThread().setName(this.scheduler.getName() + ":" + this.name);
                }
                catch (RuntimeException runtimeException) {
                    // empty catch block
                }
                this.runner.run();
                this.failures = 0;
            }
            catch (Throwable t) {
                if (this.maxFailures < 0 || ++this.failures < this.maxFailures) {
                    if (this.scheduler.log != null) {
                        this.scheduler.log.log(this.level, "Exception thrown by periodic task " + this.name, t);
                    }
                    break block16;
                }
                if (this.scheduler.log != null) {
                    this.scheduler.log.log(this.level, "Exception thrown by periodic task " + this.name + ", task terminated.", t);
                }
                throw t;
            }
            finally {
                try {
                    Thread.currentThread().setName(this.scheduler.getName());
                }
                catch (RuntimeException runtimeException) {}
            }
        }
    }

    public int getFailures() {
        return this.failures;
    }

    public int getMaxFailures() {
        return this.maxFailures;
    }

    @Override
    public long getDelay(TimeUnit unit) {
        return this.delegate.getDelay(unit);
    }

    @Override
    public int compareTo(Delayed o) {
        return this.delegate.compareTo(o);
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        this.cancelLatch.countDown();
        return this.delegate.cancel(mayInterruptIfRunning);
    }

    @Override
    public boolean isCancelled() {
        return this.cancelLatch.getCount() == 0L;
    }

    @Override
    public boolean isDone() {
        return this.cancelLatch.getCount() == 0L || this.delegate.isDone();
    }

    @Override
    public Void get() throws InterruptedException, ExecutionException {
        this.cancelLatch.await();
        this.delegate.get();
        return null;
    }

    @Override
    public Void get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        long deadline = unit.toNanos(timeout) + System.nanoTime();
        this.cancelLatch.await(timeout, unit);
        this.delegate.get(deadline - System.nanoTime(), TimeUnit.NANOSECONDS);
        return null;
    }

    public void setMaxFailures(int maxFailures) {
        this.maxFailures = maxFailures;
    }

    public synchronized void setPeriod(long period, TimeUnit unit) {
        this.delegate.cancel(false);
        this.delegate = STOPPED;
        if (period > 0L) {
            this.period = unit.toNanos(period);
            if (!this.isStopped) {
                this.isStopped = true;
                this.start();
            }
        } else {
            this.period = 0L;
        }
    }

    public synchronized long getPeriod(TimeUnit unit) {
        return unit.convert(this.period, TimeUnit.NANOSECONDS);
    }

    public synchronized void stop() {
        if (!this.isStopped) {
            this.isStopped = true;
            this.delegate.cancel(false);
            this.delegate = STOPPED;
        }
    }

    public synchronized void stop(long timeout, TimeUnit unit) throws InterruptedException, TimeoutException {
        if (!this.isStopped) {
            this.isStopped = true;
            this.delegate.cancel(false);
            ScheduledFuture<?> old = this.delegate;
            this.delegate = STOPPED;
            try {
                old.get(timeout, unit);
            }
            catch (ExecutionException executionException) {
                // empty catch block
            }
        }
    }

    public synchronized boolean start() {
        return this.start(0L, TimeUnit.NANOSECONDS);
    }

    public synchronized boolean start(long initialDelay, TimeUnit unit) {
        if (this.isStopped) {
            this.isStopped = false;
            if (this.period > 0L) {
                initialDelay = unit.toNanos(initialDelay);
                this.delegate = this.isFixedRate ? this.scheduler.executor.scheduleAtFixedRate(this, initialDelay, this.period, TimeUnit.NANOSECONDS) : this.scheduler.executor.scheduleWithFixedDelay(this, initialDelay, this.period, TimeUnit.NANOSECONDS);
                return true;
            }
        }
        return false;
    }

    public String getTaskName() {
        return this.name;
    }

    private static class SuspendedTask
    implements ScheduledFuture<Void> {
        private SuspendedTask() {
        }

        @Override
        public long getDelay(TimeUnit unit) {
            return 0L;
        }

        @Override
        public int compareTo(Delayed o) {
            return 0;
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            return true;
        }

        @Override
        public boolean isCancelled() {
            return true;
        }

        @Override
        public boolean isDone() {
            return false;
        }

        @Override
        public Void get() throws InterruptedException, ExecutionException {
            return null;
        }

        @Override
        public Void get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            return null;
        }
    }
}

