/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.command;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.lsst.ccs.command.AmbiguousCommandException;
import org.lsst.ccs.command.BasicCommand;
import org.lsst.ccs.command.CommandArgumentMatchException;
import org.lsst.ccs.command.DefaultDictionaryCompleter;
import org.lsst.ccs.command.Dictionary;
import org.lsst.ccs.command.DictionaryCommand;
import org.lsst.ccs.command.DictionaryCompleter;
import org.lsst.ccs.command.DictionaryUtils;
import org.lsst.ccs.command.annotations.Command;

class MethodBasedCommandDictionary
extends ArrayList<DictionaryCommand>
implements Dictionary {
    private static final long serialVersionUID = 4401762766383746012L;
    private final DefaultDictionaryCompleter completer = new DefaultDictionaryCompleter(this);
    private transient Map<Command.CommandType, Integer> levelsByType = Collections.synchronizedMap(new LinkedHashMap());
    private transient Map<String, Boolean> visibilityByCategory = Collections.synchronizedMap(new LinkedHashMap());

    MethodBasedCommandDictionary() {
        this.setDefaultVisibilityForCategories();
    }

    private void setDefaultVisibilityForCategories() {
        this.visibilityByCategory.put(Command.CommandCategory.USER.name(), Boolean.TRUE);
        this.visibilityByCategory.put(Command.CommandCategory.CORE.name(), Boolean.TRUE);
        this.visibilityByCategory.put(Command.CommandCategory.SYSTEM.name(), Boolean.FALSE);
    }

    @Override
    public boolean containsCommand(BasicCommand tc) throws CommandArgumentMatchException {
        return this.findCommand(tc) != null;
    }

    @Override
    public DictionaryCommand findCommand(BasicCommand tc) throws CommandArgumentMatchException {
        String command = tc.getCommand();
        int argumentCount = tc.getArgumentCount();
        ArrayList<DictionaryCommand> matches = new ArrayList<DictionaryCommand>();
        ArrayList<CommandArgumentMatchException> exceptions = new ArrayList<CommandArgumentMatchException>();
        for (DictionaryCommand def : this) {
            try {
                if (!DictionaryUtils.commandMatch(def, tc)) continue;
                matches.add(def);
            }
            catch (CommandArgumentMatchException ex) {
                exceptions.add(ex);
            }
        }
        if (matches.isEmpty()) {
            CommandArgumentMatchException.throwExceptionIfNeeded(exceptions);
            return null;
        }
        if (matches.size() == 1) {
            return (DictionaryCommand)matches.get(0);
        }
        throw new AmbiguousCommandException("Error finding command " + command + " with " + argumentCount + " arguments: " + matches.size() + " matches found in MethodBasedCommandDictionary");
    }

    @Override
    public DictionaryCompleter getDictionaryCompleter() {
        return this.completer;
    }

    @Override
    public void setLevelForTypes(int level, Command.CommandType ... types) {
        if (types == null || types.length == 0) {
            types = Command.CommandType.values();
        }
        for (Command.CommandType type : types) {
            this.levelsByType.put(type, level);
        }
    }

    @Override
    public int getLevelForType(Command.CommandType type) {
        return this.levelsByType.getOrDefault((Object)type, 99999);
    }

    @Override
    public boolean isCategoryVisible(Command.CommandCategory category) {
        return this.visibilityByCategory.get(category.name());
    }

    @Override
    public void setCategoryVisible(Command.CommandCategory category, boolean isVisible) {
        this.visibilityByCategory.put(category.name(), isVisible);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        if (this.levelsByType == null) {
            this.levelsByType = Collections.synchronizedMap(new LinkedHashMap());
        }
        if (this.visibilityByCategory == null) {
            this.visibilityByCategory = Collections.synchronizedMap(new LinkedHashMap());
        }
        if (this.visibilityByCategory.isEmpty()) {
            this.setDefaultVisibilityForCategories();
        }
    }
}

