/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.drivers.reb;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.lsst.ccs.bootstrap.BootstrapResourceUtils;
import org.lsst.ccs.drivers.reb.Daq0Client;
import org.lsst.ccs.drivers.reb.Daq1Client;
import org.lsst.ccs.drivers.reb.Daq2Client;
import org.lsst.ccs.drivers.reb.Daq4Client;
import org.lsst.ccs.drivers.reb.GlobalClient;
import org.lsst.ccs.drivers.reb.ImageClient;
import org.lsst.ccs.drivers.reb.PciClient;
import org.lsst.ccs.drivers.reb.REBException;
import org.lsst.ccs.drivers.reb.RegClient;

public class ClientFactory {
    private static final String libPathPropertyName = "org.lsst.ccs.ld.library.path";
    private static final Map<String, Integer> daqTypeMap = new HashMap<String, Integer>();
    private static final Map<Integer, String> invDaqTypeMap;
    private static final Logger LOG;
    private static boolean daqLibReported;

    public RegClient.Impl createRegClient(int hdw) throws REBException {
        int hdwType = ClientFactory.checkHdwType(hdw);
        switch (hdwType) {
            case 0: {
                return new Daq0Client.Registers();
            }
            case 1: {
                return new Daq1Client.Registers();
            }
            case 2: {
                return new Daq2Client.Registers();
            }
            case 5: {
                return new Daq4Client.Registers();
            }
            case 3: 
            case 4: {
                return new PciClient.Registers();
            }
        }
        throw new REBException("Invalid hardware type (" + hdwType + ")");
    }

    public ImageClient.Impl createImageClient(int hdw, RegClient reg) throws REBException {
        int hdwType = ClientFactory.checkHdwType(hdw);
        switch (hdwType) {
            case 0: {
                return new Daq0Client.Images();
            }
            case 1: {
                return new Daq1Client.Images();
            }
            case 2: {
                return new Daq2Client.Images();
            }
            case 5: {
                return new Daq4Client.Images();
            }
            case 3: {
                return new PciClient.Images(reg, 0);
            }
            case 4: {
                return new PciClient.Images(reg, 1);
            }
        }
        throw new REBException("Invalid hardware type (" + hdwType + ")");
    }

    public GlobalClient.Impl createGlobalClient(int hdw) throws REBException {
        int hdwType = ClientFactory.checkHdwType(hdw);
        switch (hdwType) {
            case 0: {
                return new Daq0Client.Global();
            }
            case 1: {
                return new Daq1Client.Global();
            }
            case 2: {
                return new Daq2Client.Global();
            }
            case 5: {
                return new Daq4Client.Global();
            }
            case 3: 
            case 4: {
                return new PciClient.Global();
            }
        }
        throw new REBException("Invalid hardware type (" + hdwType + ")");
    }

    private static int checkHdwType(int hdw) {
        if (hdw == 0 || hdw == 3 || hdw == 4) {
            return hdw;
        }
        Properties props = BootstrapResourceUtils.getBootstrapSystemProperties();
        String libPath = props.getProperty(libPathPropertyName);
        if (libPath == null) {
            LOG.severe("Bootstrap property org.lsst.ccs.ld.library.path not defined");
            return hdw;
        }
        Integer libType = daqTypeMap.get(libPath);
        if (libType == null) {
            LOG.log(Level.SEVERE, "Bootstrap property org.lsst.ccs.ld.library.path has invalid value ({0})", libPath);
            return hdw;
        }
        if (hdw == 6) {
            if (!daqLibReported) {
                LOG.log(Level.INFO, "Using {0} library", libPath);
                daqLibReported = true;
            }
            return libType;
        }
        if (hdw != libType) {
            LOG.log(Level.SEVERE, "{0} libray doesn''t match requested hardware type ({1})", new Object[]{libPath, invDaqTypeMap.get(hdw)});
        }
        return hdw;
    }

    static {
        daqTypeMap.put("Daq1", 1);
        daqTypeMap.put("Daq2", 2);
        daqTypeMap.put("Daq4", 5);
        invDaqTypeMap = new HashMap<Integer, String>();
        for (String name : daqTypeMap.keySet()) {
            invDaqTypeMap.put(daqTypeMap.get(name), name);
        }
        LOG = Logger.getLogger(ClientFactory.class.getName());
        daqLibReported = false;
    }
}

