/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.drivers.reb.sim;

import org.lsst.ccs.drivers.reb.ClientFactory;
import org.lsst.ccs.drivers.reb.GlobalClient;
import org.lsst.ccs.drivers.reb.ImageClient;
import org.lsst.ccs.drivers.reb.REBException;
import org.lsst.ccs.drivers.reb.RegClient;
import org.lsst.ccs.drivers.reb.sim.AddressSpace;
import org.lsst.ccs.drivers.reb.sim.DataProvider;
import org.lsst.ccs.drivers.reb.sim.GlobalClientSimulation;
import org.lsst.ccs.drivers.reb.sim.HandleAndIdManager;
import org.lsst.ccs.drivers.reb.sim.ImageClientDaq1Simulation;
import org.lsst.ccs.drivers.reb.sim.REB3Simulation;
import org.lsst.ccs.drivers.reb.sim.RegClientDaq1Simulation;
import org.lsst.ccs.drivers.reb.sim.TrivialDataProvider;

public class ClientFactorySimulation
extends ClientFactory {
    private final HandleAndIdManager manager = new HandleAndIdManager(this);

    @Override
    public RegClient.Impl createRegClient(int hdw) throws REBException {
        switch (hdw) {
            case 1: 
            case 2: {
                return new RegClientDaq1Simulation(this.manager);
            }
        }
        throw new REBException("Invalid hardware type (" + hdw + ")");
    }

    @Override
    public ImageClient.Impl createImageClient(int hdw, RegClient reg) throws REBException {
        switch (hdw) {
            case 1: 
            case 2: {
                DataProvider provider = this.createDataProvider();
                return new ImageClientDaq1Simulation(this.manager, provider);
            }
        }
        throw new REBException("Invalid hardware type (" + hdw + ")");
    }

    @Override
    public GlobalClient.Impl createGlobalClient(int hdw) throws REBException {
        switch (hdw) {
            case 1: 
            case 2: {
                return new GlobalClientSimulation(this.manager);
            }
        }
        throw new REBException("Invalid hardware type (" + hdw + ")");
    }

    AddressSpace createREBSimulation(int id) {
        return new REB3Simulation(id);
    }

    protected DataProvider createDataProvider() {
        return new TrivialDataProvider();
    }

    public AddressSpace getAddressSpaceForId(int id) {
        return this.manager.getAddressSpaceForId(id);
    }
}

