package org.lsst.ccs.drivers.reb.sim;

import java.util.concurrent.locks.ReentrantLock;

/**
 * Simplify use of reentrant lock, allowing:
 * <pre>
 *    try (AutoCloseableReentrantLock lock = lock.open()) {
 *      // Do stuff
 *    }
 * </pre>
 * @author tonyj
 */
public class AutoCloseableReentrantLock extends ReentrantLock implements AutoCloseable { 
   public AutoCloseableReentrantLock open() { 
      this.lock();
      return this;
   }

   @Override
   public void close() {
      this.unlock();
   }
}