package org.lsst.ccs.drivers.reb;

import java.io.PrintStream;

public class TestSlow {

    static final PrintStream out = System.out;

    public static void main(String[] args) throws REBException {
        int id = 0;
        String ifc = "";
        if (args.length < 1) {
            out.println("No REB ID specified");
            System.exit(0);
        }
        try {
            id = Integer.valueOf(args[0]);
        }
        catch (NumberFormatException e) {
            out.println("Invalid REB ID");
            System.exit(0);
        }
        if (args.length < 2) {
            out.println("No network interface name specified");
            System.exit(0);
        }
        ifc = args[1];
        RegClient reg = new RegClient();
        reg.open(id, ifc);

        for (int j = 0; j < 256; j++) {
            int k = ((j << 4) | (j >> 4)) & 0xff;
            reg.write(0x600101, k);
            int value = reg.read(0x601010);
            value = (value & 0xffff0000) | reverse(value & 0xffff);
            out.format("  %02x: %08x", k, value);
            if ((j & 3) == 3) {
                out.println();
            }
        }

        out.println();
        reg.write(0x600100, 0);
        for (int j = 0; j < 6; j++) {
            int value = reg.read(0x601000 + j);
            value = (value & 0xffff0000) | reverse(value & 0xffff);
            out.format("  %08x", value);
        }
        out.println();

        reg.close();
    }


    private static int reverse(int value) {

        final int[] revTab = {0, 8, 4, 12, 2, 10, 6, 14,
                              1, 9, 5, 13, 3, 11, 7, 15};
        int result = 0;
        for (int j = 0; j < 4; j++) {
            result <<= 4;
            result |= revTab[value & 0x0f];
            value >>= 4;
        }
        return result;
    }

}
