package org.lsst.ccs.drivers.reb;

/**
 * A factory class for creating RegClient and ImageClient instances. Replacing
 * the default implementation with an alternative allows simulated clients to be
 * substituted for the real ones.
 *
 * @author tonyj
 */
public class ClientFactory {

    public RegClient.Impl createRegClient(int hdw) throws REBException {
        switch (hdw) {
        case RegClient.HDW_TYPE_DAQ0:
            return new Daq0Client.Registers();
        case RegClient.HDW_TYPE_DAQ1:
            return new Daq1Client.Registers();
        case RegClient.HDW_TYPE_DAQ2:
            return new Daq2Client.Registers();
        case RegClient.HDW_TYPE_PCI0:
        case RegClient.HDW_TYPE_PCI1:
            return new PciClient.Registers();
        default:
            throw new REBException("Invalid hardware type (" + hdw + ")");
        }
    }

    public ImageClient.Impl createImageClient(int hdw, RegClient reg) throws REBException {
        switch (hdw) {
        case RegClient.HDW_TYPE_DAQ0:
            return new Daq0Client.Images();
        case RegClient.HDW_TYPE_DAQ1:
            return new Daq1Client.Images();
        case RegClient.HDW_TYPE_DAQ2:
            return new Daq2Client.Images();
        case RegClient.HDW_TYPE_PCI0:
            return new PciClient.Images(reg, 0);
        case RegClient.HDW_TYPE_PCI1:
            return new PciClient.Images(reg, 1);
        default:
            throw new REBException("Invalid hardware type (" + hdw + ")");
        }
    }

    public GlobalClient.Impl createGlobalClient(int hdw) throws REBException {
        switch (hdw) {
        case RegClient.HDW_TYPE_DAQ0:
            return new Daq0Client.Global();
        case RegClient.HDW_TYPE_DAQ1:
            return new Daq1Client.Global();
        case RegClient.HDW_TYPE_DAQ2:
            return new Daq2Client.Global();
        case RegClient.HDW_TYPE_PCI0:
        case RegClient.HDW_TYPE_PCI1:
            return new PciClient.Global();
        default:
            throw new REBException("Invalid hardware type (" + hdw + ")");
        }
    }

}
