/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.drivers.reb;

import java.util.HashMap;
import java.util.Map;
import org.lsst.ccs.drivers.reb.BaseSet;
import org.lsst.ccs.drivers.reb.REBException;

public class TempAdcs {
    public static final int REG_TEMP_ADCS = 0x600010;
    public static final int NUM_TEMP_REGS_S = 10;
    public static final int NUM_TEMP_REGS_S0 = 11;
    public static final int NUM_TEMP_REGS_W = 6;
    public static final int NUM_TEMP_REGS_G = 10;
    public static final int NUM_TEMP_REGS_M = 11;
    public static final int ERROR_MASK = 65536;
    public static final double TEMP_SCALE = 0.0078125;
    private static final Map<Integer, Integer> numRegsMap = new HashMap<Integer, Integer>();
    private final BaseSet bss;

    public TempAdcs(BaseSet bss) {
        this.bss = bss;
    }

    public void enable() throws REBException {
        this.bss.getVersion(8);
        this.bss.enable(4);
    }

    public void waitDone() throws REBException {
        this.bss.getVersion(8);
        this.bss.waitDone(4);
    }

    public long getTriggerTime() throws REBException {
        this.bss.checkNotVersion(8, 0);
        return this.bss.getTriggerTime(4);
    }

    public double readAdc(int adc) throws REBException {
        if (adc < 0 || adc >= this.getNumRegs()) {
            throw new REBException("Invalid temperature ADC number");
        }
        this.enable();
        this.waitDone();
        int value = this.bss.read(0x600010 + adc);
        return (value & 0x10000) != 0 ? BaseSet.ERROR_VALUE : 0.0078125 * (double)((short)value);
    }

    public double[] readAdcs() throws REBException {
        return this.readAdcs(0, this.getNumRegs());
    }

    public double[] readAdcs(int first, int count) throws REBException {
        if (first < 0 || count < 0 || first + count > this.getNumRegs()) {
            throw new REBException("Invalid temperature ADC range");
        }
        this.enable();
        this.waitDone();
        int[] rawData = new int[count];
        double[] data = new double[count];
        this.bss.read(0x600010 + first, rawData);
        for (int j = 0; j < count; ++j) {
            int value = rawData[j];
            data[j] = (value & 0x10000) != 0 ? BaseSet.ERROR_VALUE : 0.0078125 * (double)((short)value);
        }
        return data;
    }

    public int getNumRegs() throws REBException {
        return numRegsMap.get(this.bss.getVersion(8));
    }

    static {
        numRegsMap.put(0, 11);
        numRegsMap.put(1, 11);
        numRegsMap.put(2, 6);
        numRegsMap.put(3, 10);
        numRegsMap.put(4, 10);
    }
}

