/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.drivers.reb;

import java.io.IOException;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import org.lsst.ccs.command.annotations.Argument;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.drivers.reb.Aspic;
import org.lsst.ccs.drivers.reb.BaseSet;
import org.lsst.ccs.drivers.reb.BoardDacs;
import org.lsst.ccs.drivers.reb.Cabac;
import org.lsst.ccs.drivers.reb.ClientFactory;
import org.lsst.ccs.drivers.reb.PowerAdcs;
import org.lsst.ccs.drivers.reb.REBException;
import org.lsst.ccs.drivers.reb.SequencerUtils;
import org.lsst.ccs.drivers.reb.SlowAdcs;
import org.lsst.ccs.drivers.reb.Status;
import org.lsst.ccs.drivers.reb.StatusSet;
import org.lsst.ccs.drivers.reb.TempAdcs;
import org.lsst.ccs.drivers.reb.TempRtds;

public class TestReg {
    private static final Map<String, Integer> cabacMap = new LinkedHashMap<String, Integer>();
    private static final String CUP = "\u001b[A";
    private final BaseSet bset = new BaseSet();
    private final SequencerUtils seq = new SequencerUtils(this.bset);
    private final StatusSet sset = new StatusSet(this.bset);
    private final TempAdcs tmp = new TempAdcs(this.bset);
    final TempRtds rtd = new TempRtds(this.bset);
    private final PowerAdcs pwr = new PowerAdcs(this.bset);
    private final BoardDacs dac = new BoardDacs(this.bset);
    private final Cabac cab = new Cabac(this.bset);
    private final Aspic asp = new Aspic(this.bset);
    private final SlowAdcs sad = new SlowAdcs(this.bset);
    private int rebId = -1;
    private final ConsThread consThread = new ConsThread();

    public final void setClientFactory(ClientFactory clientFactory) {
        this.bset.setClientFactory(clientFactory);
    }

    @Command(name="connect", description="Connect to a REB")
    public void connect(@Argument(name="id", description="REB ID") int id) throws REBException {
        this.rebId = id;
        this.bset.open(this.rebId);
    }

    @Command(name="connect", description="Connect to a REB")
    public void connect(@Argument(name="id", description="REB ID") int id, @Argument(name="ifcname", description="Network interface name") String ifcName) throws REBException {
        this.rebId = id;
        this.bset.open(this.rebId, ifcName);
    }

    @Command(name="connect", description="Connect to a REB")
    public void connect(@Argument(name="type", description="Hardware type") HdwType type, @Argument(name="id", description="REB ID") int id, @Argument(name="ifcname", description="Network interface name") String ifcName) throws REBException {
        this.rebId = id;
        this.bset.open(type.getValue(), this.rebId, ifcName);
    }

    @Command(name="disconnect", description="Disconnect from a REB")
    public void disconnect() throws REBException {
        this.bset.close();
        this.rebId = -1;
    }

    @Command(name="show", description="Show connection parameters")
    public String show() throws REBException {
        boolean connected = false;
        int version = -1;
        this.bset.checkOpen();
        connected = true;
        version = this.bset.getFwVersion();
        return "Connection parameters:\n  Connected  = " + connected + "\n  REB id     = " + this.rebId + "\n  FWVersion  = " + version;
    }

    @Command(name="read", description="Show one register")
    public String read(@Argument(name="address", description="Register address to read") int address) throws REBException {
        return String.format("%06x: %08x", address, this.bset.read(address));
    }

    @Command(name="read", description="Show one or more registers")
    public String read(@Argument(name="address", description="First register address to read") int address, @Argument(name="count", description="Number of registers to read") int count) throws REBException {
        int[] values = new int[count];
        this.bset.read(address, values);
        StringBuilder result = new StringBuilder(9 * (count + (count + 3) / 4));
        int j = 0;
        while (j < count) {
            if ((j & 3) == 0) {
                if (j != 0) {
                    result.append("\n");
                }
                result.append(String.format("%06x:", address));
            }
            result.append(String.format(" %08x", values[j]));
            ++j;
            ++address;
        }
        return result.toString();
    }

    @Command(name="write", description="Write a register")
    public void write(@Argument(name="address", description="Register address to write") int address, @Argument(name="value", description="Value to write") int value) throws REBException {
        this.bset.write(address, value);
    }

    @Command(name="update", description="Update a register")
    public void update(@Argument(name="address", description="Address of register to update") int address, @Argument(name="mask", description="Mask of bits to update") int mask, @Argument(name="value", description="New value to write") int value) throws REBException {
        this.bset.update(address, mask, value);
    }

    @Command(name="readlong", description="Show a pair of registers")
    public String readLong(@Argument(name="address", description="Address of first register to read") int address) throws REBException {
        return String.format("%06x: %016x", address, this.bset.readLong(address));
    }

    @Command(name="writelong", description="Write a pair of registers")
    public void writeLong(@Argument(name="address", description="Address of first register to write") int address, @Argument(name="value", description="Value to write") long value) throws REBException {
        this.bset.writeLong(address, value);
    }

    @Command(name="enable", description="Enable a register set")
    public void enable(@Argument(name="regset", description="Register set name") RsetId regset) throws REBException {
        this.bset.enable(regset.getValue());
    }

    @Command(name="disable", description="Disable a register set")
    public void disable(@Argument(name="regset", description="Register set name") RsetId regset) throws REBException {
        this.bset.disable(regset.getValue());
    }

    @Command(name="trigtime", description="Show a trigger time")
    public String trigtime(@Argument(name="regset", description="Register set name") RsetId regset) throws REBException {
        long time = this.bset.getTriggerTime(regset.getValue());
        GregorianCalendar tm = new GregorianCalendar();
        tm.setTimeInMillis(time);
        return String.format("Time = %tY-%<tm-%<td %<tH:%<tM:%<tS.%<tL", tm);
    }

    @Command(name="time", description="Show the time")
    public String time() throws REBException {
        long time = this.bset.getTime();
        GregorianCalendar tm = new GregorianCalendar();
        tm.setTimeInMillis(time);
        return String.format("Time = %tY-%<tm-%<td %<tH:%<tM:%<tS.%<tL", tm);
    }

    @Command(name="time", description="Set the time")
    public String setTime(@Argument(name="time", description="The time to set") String time) throws REBException {
        String result = CUP;
        if (time.equals(".")) {
            this.bset.setTime();
        } else {
            SimpleDateFormat fmt = new SimpleDateFormat();
            fmt.setLenient(true);
            fmt.applyPattern("y-M-d H:m:s");
            ParsePosition pos = new ParsePosition(0);
            Date date = fmt.parse(time, pos);
            if (date == null) {
                result = "Expected format is yyyy-mm-dd hh:mm:ss";
            } else {
                this.bset.setTime(date.getTime());
            }
        }
        return result;
    }

    @Command(name="timebase", description="Show the time base")
    public String timebase() throws REBException {
        return "Value = " + this.bset.getTimeRaw();
    }

    @Command(name="timebase", description="Set the time base")
    public void timebase(@Argument(name="time", description="The value to set") long time) throws REBException {
        this.bset.setTimeRaw(time);
    }

    @Command(name="loadtest", description="Load sequencer with test program")
    public void loadTest(@Argument(name="totTime", description="The total time per cycle") int totTime, @Argument(name="ncycle", description="The number of cycles") int ncycle) throws REBException {
        this.loadTest(totTime, ncycle, 10);
    }

    @Command(name="loadtest", description="Load sequencer with test program")
    public void loadTest(@Argument(name="totTime", description="The total time per cycle") int totTime, @Argument(name="ncycle", description="The number of cycles") int ncycle, @Argument(name="ontime", description="The time the ADC is on per cycle") int onTime) throws REBException {
        this.seq.writeLines(0, new int[]{0});
        this.seq.writeLines(1, new int[]{4096, 0});
        this.seq.writeTimes(1, new int[]{onTime, totTime - onTime, 0});
        if (this.seq.getVersion() == 0) {
            this.seq.writeStack(new int[]{0x10000000 | ncycle & 0x3FFFFFF});
            this.seq.writeDataSource(0);
        } else {
            this.seq.writeProgExec(0, 1, ncycle);
            this.seq.writeProgEnd(1);
            this.seq.writeDataSource(1);
        }
        this.seq.writeSliceCount(ncycle);
    }

    @Command(name="loadcommand", description="Load command into sequencer")
    public void loadCommand(@Argument(name="command", description="The command to load") String command) throws REBException {
        this.seq.loadCommand(command);
    }

    @Command(name="loadfile", description="Load command file into sequencer")
    public String loadFile(@Argument(name="filename", description="The name of the file to load") String fileName) throws REBException, IOException {
        int nSlice = this.seq.loadFile(fileName);
        return "Slice count = " + nSlice;
    }

    @Command(name="stop", description="Send a stop request to the sequencer")
    public void stop() throws REBException {
        this.seq.sendStop();
    }

    @Command(name="step", description="Send a step request to the sequencer")
    public void step() throws REBException {
        this.seq.sendStep();
    }

    @Command(name="slice", description="Show the slice count")
    public String sliceCount() throws REBException {
        return "Slice count = " + this.seq.readSliceCount();
    }

    @Command(name="slice", description="Set the slice count")
    public void sliceCount(@Argument(name="count", description="The value to set") int count) throws REBException {
        this.seq.writeSliceCount(count);
    }

    @Command(name="source", description="Show the data source")
    public String dataSource() throws REBException {
        return "Data source = " + this.seq.readDataSource();
    }

    @Command(name="source", description="Set the data source")
    public void dataSource(@Argument(name="value", description="The value to set") int value) throws REBException {
        this.seq.writeDataSource(value);
    }

    @Command(name="stripe", description="Show the stripe selection")
    public String stripeSelect() throws REBException {
        return "Stripe selection = " + this.seq.readStripeSelect();
    }

    @Command(name="stripe", description="Set the stripe selection")
    public void stripeSelect(@Argument(name="value", description="The value to set") int value) throws REBException {
        this.seq.writeStripeSelect(value);
    }

    @Command(name="scan", description="Show the scan mode")
    public String scanMode() throws REBException {
        return "Scan mode is " + (this.seq.isScanEnabled() ? "on" : "off");
    }

    @Command(name="scan", description="Set/reset the scan mode")
    public void sliceCount(@Argument(name="option", description="The scan mode option") ScanOption option) throws REBException {
        if (option == ScanOption.RESET) {
            this.seq.resetScan();
        } else {
            this.seq.enableScan(option == ScanOption.ON);
        }
    }

    @Command(name="status", description="Show status block contents")
    public String showStatus() throws REBException {
        int j;
        Status status = this.sset.readStatus();
        StringBuilder result = new StringBuilder();
        result.append("Status Block:\n");
        result.append(String.format("  Version               = %08x  ", status.getVersion()));
        result.append(String.format("  Link Status           = %08x\n", status.getLinkStatus()));
        result.append(String.format("  Cell error count      = %-8s  ", status.getCellErrorCount()));
        result.append(String.format("  Link down count       = %s\n", status.getLinkDownCount()));
        result.append(String.format("  Link error count      = %-8s  ", status.getLinkErrorCount()));
        result.append(String.format("  VC buffer status      = %08x\n", status.getVcBufferStatus()));
        int[] counts = status.getVcRxCounts();
        result.append("  VC rcve counts        =");
        for (j = 0; j < counts.length; ++j) {
            result.append(String.format(" %s", counts[j]));
        }
        result.append("\n");
        counts = status.getVcTxCounts();
        result.append("  VC xmit counts        =");
        for (j = 0; j < counts.length; ++j) {
            result.append(String.format(" %s", counts[j]));
        }
        result.append("\n");
        result.append(String.format("  Sent image count      = %-8s  ", status.getSentCount()));
        result.append(String.format("  Discarded image count = %s\n", status.getDiscCount()));
        result.append(String.format("  Truncated image count = %-8s  ", status.getTruncCount()));
        result.append(String.format("  Image format          = %s", status.getFormat()));
        return result.toString();
    }

    @Command(name="temperature", description="Show all board temperatures")
    public String temperature() throws REBException {
        return TestReg.formatAdcs(this.tmp.readAdcs(), 0, "%.2f");
    }

    @Command(name="temperature", description="Show a board temperature")
    public String temperature(@Argument(name="first", description="The temperature to show") int first) throws REBException {
        double[] values = new double[]{this.tmp.readAdc(first)};
        return TestReg.formatAdcs(values, first, "%.2f");
    }

    @Command(name="temperature", description="Show board temperatures")
    public String temperature(@Argument(name="first", description="The first temperature to show") int first, @Argument(name="count", description="The number of temperatures to show") int count) throws REBException {
        return TestReg.formatAdcs(this.tmp.readAdcs(first, count), first, "%.2f");
    }

    @Command(name="power", description="Show all board power values")
    public String power() throws REBException {
        return TestReg.formatAdcs(this.pwr.readAdcs(), 0, "%.4g");
    }

    @Command(name="power", description="Show a board power value")
    public String power(@Argument(name="first", description="The power value to show") int first) throws REBException {
        double[] values = new double[]{this.pwr.readAdc(first)};
        return TestReg.formatAdcs(values, first, "%.4g");
    }

    @Command(name="power", description="Show board power values")
    public String power(@Argument(name="first", description="The first power value to show") int first, @Argument(name="count", description="The number of power values to show") int count) throws REBException {
        return TestReg.formatAdcs(this.pwr.readAdcs(first, count), first, "%.4g");
    }

    @Command(name="dacversion", description="Show DAC firmware version")
    public String dacVersion() {
        return "DAC version = " + this.dac.getVersion();
    }

    @Command(name="dacset", description="Set a DAC value")
    public void dacSet(@Argument(name="chan", description="The channel name") DacChan chan, @Argument(name="value", description="The value to set") int value) throws REBException {
        this.dac.set(chan.getValue(), value);
    }

    @Command(name="dacset", description="Set a DAC value")
    public void dacSet(@Argument(name="chan", description="The channel name") DacChan chan, @Argument(name="value", description="The value to set") int value, @Argument(name="strip", description="The strip number") int strip) throws REBException {
        this.dac.set(strip, chan.getValue(), value);
    }

    @Command(name="dacloadall", description="Load values into all DACs")
    public void dacLoadAll() throws REBException {
        this.dac.loadAll();
    }

    @Command(name="dacloadglobal", description="Load values into all global DACs")
    public void dacLoadGlobal() throws REBException {
        this.dac.loadGlobal();
    }

    @Command(name="dacloadstrip", description="Load values into all strip DACs")
    public void dacLoadStrip() throws REBException {
        this.dac.loadStrip();
    }

    @Command(name="dacloadstrip", description="Load values into one strip's DACs")
    public void dacLoadStrip(@Argument(name="strip", description="The strip number") int strip) throws REBException {
        this.dac.loadStrip(strip);
    }

    @Command(name="dacload", description="Load values into a DAC")
    public void dacLoad(@Argument(name="dac", description="The DAC name") DacName name) throws REBException {
        this.dac.load(name.getValue());
    }

    @Command(name="dacload", description="Load values into a DAC")
    public void dacLoad(@Argument(name="dac", description="The DAC name") DacName name, @Argument(name="strip", description="The strip number") int strip) throws REBException {
        this.dac.load(strip, name.getValue());
    }

    @Command(name="cabacversion", description="Show CABAC firmware version")
    public String cabacacVersion() {
        return "CABAC version = " + this.cab.getVersion();
    }

    @Command(name="cabacpower", description="Set CABAC power regulator enables")
    public void cabacacPower(@Argument(name="enables", description="The regulator enable bits") int enables) throws REBException {
        this.cab.setRegulator(enables);
    }

    @Command(name="cabacpower", description="Show CABAC power regulator")
    public String cabacacPower() throws REBException {
        return String.format("CABAC power enables = 0x%02x", this.cab.getRegulator());
    }

    @Command(name="cabacfield", description="Show a CABAC field")
    public String cabacField(@Argument(name="strips", description="The mask of strips") int strips, @Argument(name="side", description="The side (0 or 1)") int side, @Argument(name="field", description="The field name") CabacField field) throws REBException {
        int[] value = this.cab.readField(strips, side, field.getValue());
        StringBuilder text = new StringBuilder();
        int j = 0;
        int k = 0;
        while (j < this.bset.getNumStrips()) {
            if ((strips & 1) != 0) {
                text.append(k == 0 ? "Strip" : ";");
                text.append(String.format(" %s: 0x%04x", j, value[k]));
                ++k;
            }
            ++j;
            strips >>= 1;
        }
        if (text.length() == 0) {
            text.append(CUP);
        }
        return text.toString();
    }

    @Command(name="cabacfield", description="Write a CABAC field")
    public void cabacField(@Argument(name="strips", description="The mask of strips") int strips, @Argument(name="sides", description="The mask of sides") int sides, @Argument(name="field", description="The field name") CabacField field, @Argument(name="value", description="The value to set") int value) throws REBException {
        this.cab.writeField(strips, sides, field.getValue(), value);
    }

    @Command(name="cabacfetch", description="Fetch CABAC strip")
    public void cabacFetch(@Argument(name="strip", description="The strip number (0 - 2)") int strip) throws REBException {
        this.cab.fetch(strip);
    }

    @Command(name="cabacload", description="Load CABAC strip")
    public void cabacLoad(@Argument(name="strip", description="The strip number (0 - 2)") int strip) throws REBException {
        this.cab.load(strip);
    }

    @Command(name="cabacclear", description="Clear CABAC strip")
    public void cabacClear(@Argument(name="strip", description="The strip number (0 - 2)") int strip) throws REBException {
        this.cab.reset(strip);
    }

    @Command(name="cabacread", description="Show CABAC input registers")
    public String cabacRead(@Argument(name="side", description="The side (0 or 1)") int side) throws REBException {
        int[] data = this.cab.readRaw(side);
        StringBuilder result = new StringBuilder("Values =");
        for (int value : data) {
            result.append(String.format(" 0x%08x", value));
        }
        return result.toString();
    }

    @Command(name="cabacwrite", description="Write CABAC output registers")
    public void cabacWrite(@Argument(name="side", description="The side (0 or 1)") int side, int ... values) throws REBException {
        this.cab.writeRaw(side, values);
    }

    @Command(name="cabaccopy", description="Copy CABAC registers")
    public void cabacCopy(@Argument(name="side", description="The side (0 or 1)") int side) throws REBException {
        this.cab.copyRaw(side);
    }

    @Command(name="cabac", description="Show all fields of a CABAC")
    public String cabac(@Argument(name="side", description="The side (0 or 1)") int side) throws REBException {
        int[] data = this.cab.get(side);
        StringBuilder result = new StringBuilder();
        int count = 0;
        for (String name : cabacMap.keySet()) {
            if (count > 0 && count % 4 == 0) {
                result.append("\n");
            }
            result.append(String.format("  %-7s = %-5s", name, data[cabacMap.get(name)]));
            ++count;
        }
        return result.toString();
    }

    @Command(name="cabac", description="Show a CABAC field")
    public String cabac(@Argument(name="side", description="The side (0 or 1)") int side, @Argument(name="field", description="The field name") CabacField field) throws REBException {
        return field.name() + " = " + this.cab.get(side, field.getValue());
    }

    @Command(name="cabacsetall", description="Set all CABAC fields")
    public void cabacSet(@Argument(name="side", description="The side (0 or 1)") int side, int ... values) throws REBException {
        this.cab.set(side, values);
    }

    @Command(name="cabacset", description="Set a CABAC field")
    public void cabacSet(@Argument(name="side", description="The side (0 or 1)") int side, @Argument(name="field", description="The field name") CabacField field, @Argument(name="value", description="The value to set") int value) throws REBException {
        this.cab.set(side, field.getValue(), value);
    }

    @Command(name="aspicversion", description="Show ASPIC firmware version")
    public String aspicVersion() {
        return "ASPIC version = " + this.asp.getVersion();
    }

    @Command(name="aspicgainrc", description="Show ASPIC gain & RC")
    public String aspicGainRc(@Argument(name="strips", description="The mask of strips") int strips, @Argument(name="side", description="The side (0 or 1)") int side) throws REBException {
        int[][] value = this.asp.readGainRc(strips, side);
        StringBuilder text = new StringBuilder();
        int j = 0;
        int k = 0;
        while (j < this.bset.getNumStrips()) {
            if ((strips & 1) != 0) {
                text.append(k == 0 ? "Strip" : ";");
                text.append(String.format(" %s: gain = %s, rc = %s", j, value[k][0], value[k][1]));
                ++k;
            }
            ++j;
            strips >>= 1;
        }
        if (text.length() == 0) {
            text.append(CUP);
        }
        return text.toString();
    }

    @Command(name="aspicgainrc", description="Set ASPIC gain & RC")
    public void aspicGainRc(@Argument(name="strips", description="The mask of strips") int strips, @Argument(name="sides", description="The mask of sides") int sides, @Argument(name="gain", description="The gain") int gain, @Argument(name="rc", description="The RC value") int rc) throws REBException {
        this.asp.writeGainRc(strips, sides, gain, rc);
    }

    @Command(name="aspicclamp", description="Show ASPIC clamp value")
    public String aspicClamp(@Argument(name="strips", description="The mask of strips") int strips, @Argument(name="side", description="The side (0 or 1)") int side) throws REBException {
        int[] value = this.asp.readClamp(strips, side);
        StringBuilder text = new StringBuilder();
        int j = 0;
        int k = 0;
        while (j < this.bset.getNumStrips()) {
            if ((strips & 1) != 0) {
                text.append(k == 0 ? "Strip" : ";");
                text.append(String.format(" %s: 0x%02x", j, value[k]));
                ++k;
            }
            ++j;
            strips >>= 1;
        }
        if (text.length() == 0) {
            text.append(CUP);
        }
        return text.toString();
    }

    @Command(name="aspicclamp", description="Set ASPIC clamp value")
    public void aspicClamp(@Argument(name="strips", description="The mask of strips") int strips, @Argument(name="sides", description="The mask of sides") int sides, @Argument(name="clamp", description="The clamp value") int clamp) throws REBException {
        this.asp.writeClamp(strips, sides, clamp);
    }

    @Command(name="aspicmodes", description="Show ASPIC modes")
    public String aspicModes(@Argument(name="strips", description="The mask of strips") int strips, @Argument(name="side", description="The side (0 or 1)") int side) throws REBException {
        int[] value = this.asp.readModes(strips, side);
        StringBuilder text = new StringBuilder();
        int j = 0;
        int k = 0;
        while (j < this.bset.getNumStrips()) {
            if ((strips & 1) != 0) {
                text.append(k == 0 ? "Strip" : ";");
                text.append(String.format(" %s: 0x%02x", j, value[k]));
                ++k;
            }
            ++j;
            strips >>= 1;
        }
        if (text.length() == 0) {
            text.append(CUP);
        }
        return text.toString();
    }

    @Command(name="aspicmodes", description="Set ASPIC modes")
    public void aspicModes(@Argument(name="strips", description="The mask of strips") int strips, @Argument(name="sides", description="The mask of sides") int sides, @Argument(name="modes", description="The modes value") int modes) throws REBException {
        this.asp.writeModes(strips, sides, modes);
    }

    @Command(name="aspictemps", description="Show all ASPIC temperatures")
    public String aspicTemps() throws REBException {
        return this.aspicTemps(0, this.sad.getNumAspicTemps());
    }

    @Command(name="aspictemps", description="Show ASPIC temperature")
    public String aspicTemps(@Argument(name="first", description="The ASPIC to read") int first) throws REBException {
        return this.aspicTemps(first, 1);
    }

    @Command(name="aspictemps", description="Show ASPIC temperatures")
    public String aspicTemps(@Argument(name="first", description="The first ASPIC to read") int first, @Argument(name="count", description="The number of ASPICs") int count) throws REBException {
        return TestReg.formatAdcs(this.sad.readAspicTemps(first, count), first, "%.1f");
    }

    @Command(name="slowadc", description="Show slow ADC raw value")
    public String slowAdc(@Argument(name="mux", description="The MUX channel number") int mux, @Argument(name="adc", description="The ADC channel number") int adc) throws REBException {
        int config = mux << 4 | adc & 0xF;
        return "Value = " + this.sad.readDirect(config);
    }

    @Command(name="voltage", description="Show slow ADC voltage")
    public String voltage(@Argument(name="channel", description="The channel to read") VoltsChan chan) throws REBException {
        return "Value = " + String.format("%.4g", this.sad.readVoltage(chan.getValue()));
    }

    @Command(name="current", description="Show slow ADC current")
    public String current(@Argument(name="strip", description="The strip number") int strip, @Argument(name="side", description="The side number") int side, @Argument(name="channel", description="The channel to read") int chan) throws REBException {
        return "Value = " + String.format("%.4g", this.sad.readCurrent(strip, side, chan));
    }

    @Command(name="current", description="Show slow ADC current")
    public String current(@Argument(name="channel", description="The channel to read") int chan) throws REBException {
        return "Value = " + String.format("%.4g", this.sad.readCurrent(chan));
    }

    @Command(name="rtdinit", description="Initialize RTD ADC chip")
    public void rtdInit() throws REBException {
        this.rtd.initialize();
    }

    @Command(name="rtdreset", description="Reset RTD ADC chip")
    public void rtdReset() throws REBException {
        this.rtd.reset();
    }

    @Command(name="rtdtemperature", description="Show RTD temperature")
    public String rtdTemperature(@Argument(name="channel", description="The channel to read") int chan) throws REBException {
        return "Value = " + String.format("%.2f", this.rtd.readTemperature(chan));
    }

    @Command(name="rtdtemperature", description="Show the RTD ADC chip temperature")
    public String rtdAdcTemperature() throws REBException {
        return "Value = " + String.format("%.2f", this.rtd.readIntTemperature());
    }

    @Command(name="rtdvoltage", description="Show the RTD ADC chip voltage")
    public String rtdAdcVoltage() throws REBException {
        return "Value = " + String.format("%.2f", this.rtd.readIntVoltage());
    }

    @Command(name="rtdregister", description="Read RTD ADC chip register")
    public String rtdRegister(@Argument(name="regnum", description="The register to read") int reg) throws REBException {
        return "Value = " + String.format("0x%x", this.rtd.readRegister(reg));
    }

    @Command(name="sndreb", description="Show DREB serial number")
    public String snDreb() throws REBException {
        return "DREB serial no. = " + this.bset.getDrebSerial();
    }

    @Command(name="snreb", description="Show REB serial number")
    public String snReb() throws REBException {
        return "REB serial no. = " + this.bset.getRebSerial();
    }

    @Command(name="dcdcsync", description="Show DC/DC synchronization")
    public String dcDcSync() throws REBException {
        return "DC/DC synchronization is " + (this.bset.isDcdcSync() ? "on" : "off");
    }

    @Command(name="dcdcsync", description="Set DC/DC synchronization state")
    public void dcDcSync(@Argument(name="state", description="The state to set") OnOff state) throws REBException {
        this.bset.setDcdcSync(state == OnOff.ON);
    }

    @Command(name="contread", description="Continuously read registers")
    public String contRead(@Argument(name="address", description="The first register to read") int address, @Argument(name="count", description="The number of registers to read") int count) throws REBException {
        int[] values = new int[count];
        int nRead = 0;
        System.out.println("Press any key to terminate...");
        boolean[] done = new boolean[]{false};
        this.consThread.start(done);
        long startTime = System.currentTimeMillis();
        while (!done[0]) {
            this.bset.read(address, values);
            nRead += count;
        }
        double rate = 1000.0 * (double)nRead / (double)(System.currentTimeMillis() - startTime);
        return String.format("Read rate = %.4g Hz", rate);
    }

    @Command(name="conttemp", description="Continuously read temperatures")
    public String contTemp() throws REBException {
        int nRead = 0;
        System.out.println("Press any key to terminate...");
        boolean[] done = new boolean[]{false};
        this.consThread.start(done);
        long startTime = System.currentTimeMillis();
        while (!done[0]) {
            this.tmp.readAdcs();
            ++nRead;
        }
        double rate = 1000.0 * (double)nRead / (double)(System.currentTimeMillis() - startTime);
        return String.format("Read rate = %.4g Hz", rate);
    }

    @Command(name="contpower", description="Continuously read power values")
    public String contPower() throws REBException {
        int nRead = 0;
        System.out.println("Press any key to terminate...");
        boolean[] done = new boolean[]{false};
        this.consThread.start(done);
        long startTime = System.currentTimeMillis();
        while (!done[0]) {
            this.pwr.readAdcs();
            ++nRead;
        }
        double rate = 1000.0 * (double)nRead / (double)(System.currentTimeMillis() - startTime);
        return String.format("Read rate = %.4g Hz", rate);
    }

    private static String formatAdcs(double[] values, int index, String fmt) {
        StringBuilder result = new StringBuilder();
        for (int j = 0; j < values.length; ++j) {
            if ((j & 3) == 0) {
                result.append(j == 0 ? "ADCs:" : "\n     ");
            }
            result.append(String.format("  %2s: " + fmt, j + index, values[j]));
        }
        return result.toString();
    }

    public BaseSet getBaseSet() {
        return this.bset;
    }

    static {
        cabacMap.put("OD_EXP0", 0);
        cabacMap.put("OD_EXP1", 1);
        cabacMap.put("OD_RDO0", 2);
        cabacMap.put("OD_RDO1", 3);
        cabacMap.put("PCLK0", 4);
        cabacMap.put("PCLK1", 5);
        cabacMap.put("PCLK2", 6);
        cabacMap.put("PCLK3", 7);
        cabacMap.put("SCLK0", 8);
        cabacMap.put("SCLK1", 9);
        cabacMap.put("SCLK2", 10);
        cabacMap.put("RG", 11);
        cabacMap.put("GD", 12);
        cabacMap.put("OG", 13);
        cabacMap.put("RD", 14);
        cabacMap.put("SPH", 15);
        cabacMap.put("SPL", 16);
        cabacMap.put("MUX0", 17);
        cabacMap.put("MUX1", 18);
        cabacMap.put("PULSE", 19);
        cabacMap.put("MUXE", 20);
    }

    class ConsThread
    extends Thread {
        private final BlockingQueue<Integer> consQueue = new ArrayBlockingQueue<Integer>(1);
        private boolean[] consDone;
        private Thread mainThread;

        ConsThread() {
            this.setDaemon(true);
        }

        @Override
        public void run() {
            while (true) {
                this.awaitStart();
                this.awaitTerminal();
                this.consDone[0] = true;
                if (this.mainThread == null) continue;
                this.mainThread.interrupt();
            }
        }

        public void start(boolean[] done, boolean wake) {
            if (this.getState() == Thread.State.NEW) {
                this.start();
            }
            this.consDone = done;
            this.consDone[0] = false;
            this.mainThread = wake ? Thread.currentThread() : null;
            this.consQueue.offer(0);
        }

        public void start(boolean[] done) {
            this.start(done, false);
        }

        private void awaitStart() {
            while (true) {
                try {
                    this.consQueue.take();
                    return;
                }
                catch (InterruptedException interruptedException) {
                    continue;
                }
                break;
            }
        }

        private void awaitTerminal() {
            block6: while (true) {
                try {
                    while (System.in.available() <= 0) {
                        try {
                            Thread.sleep(50L);
                            continue block6;
                        }
                        catch (InterruptedException interruptedException) {
                        }
                    }
                    break;
                }
                catch (IOException e) {
                    // empty catch block
                    break;
                }
            }
            try {
                while (System.in.available() > 0) {
                    System.in.read();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static enum VoltsChan {
        OD0(0),
        OD1(4),
        OD2(8),
        OG0(1),
        OG1(5),
        OG2(9),
        RD0(2),
        RD1(6),
        RD2(10),
        GD0(3),
        GD1(7),
        GD2(11),
        VREF50(12),
        VREF51(13),
        VREF52(14),
        VREF251(15),
        OD(0),
        OG(1),
        RD(2),
        GD(3),
        VREF25(16),
        CKP(17),
        CKP0(17),
        CKP1(32),
        CKS(18),
        CKS0(18),
        CKS1(33),
        RG(19),
        RG0(34),
        RG1(34),
        SCKL(20),
        SCKU(21),
        RGL(22),
        RGU(23),
        CKPSH(24),
        ODI(25),
        CKPL(26),
        CKPU(27),
        VP12(28),
        VN12(29),
        VDPHI(30),
        VCLKL(31),
        ODI0(25),
        ODI1(35);

        int value;

        private VoltsChan(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }
    }

    public static enum DacChan {
        SCLKL(0),
        SCLKLSH(1),
        SCLKH(2),
        SCLKHSH(3),
        RGL(4),
        RGLSH(5),
        RGH(6),
        RGHSH(7),
        PCLKL(8),
        PCLKLSH(9),
        PCLKH(10),
        PCLKHSH(11),
        GD(13),
        RD(14),
        OG(15),
        OGSH(16),
        OD(12),
        CSGATE(17),
        HEATER(18),
        CSGATE1(17),
        CSGATE2(19),
        CSGATE3(20),
        HEATER1(18),
        HEATER2(21);

        int value;

        private DacChan(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }
    }

    public static enum DacName {
        RAILS(0),
        CSGATE(1),
        CABAC(2),
        HEATER(3),
        BIAS(16);

        int value;

        private DacName(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }
    }

    public static enum CabacField {
        OD_EXP0(0),
        OD_EXP1(1),
        OD_RDO0(2),
        OD_RDO1(3),
        PCLK0(4),
        PCLK1(5),
        PCLK2(6),
        PCLK3(7),
        SCLK0(8),
        SCLK1(9),
        SCLK2(10),
        RG(11),
        GD(12),
        OG(13),
        RD(14),
        MUX0(17),
        MUX1(18),
        PULSE(19),
        MUXE(20),
        SPH(15),
        SPL(16);

        int value;

        private CabacField(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }
    }

    public static enum OnOff {
        ON,
        OFF;

    }

    public static enum ScanOption {
        ON,
        OFF,
        RESET;

    }

    public static enum RsetId {
        STATUS(0),
        TIMEBASE(1),
        SEQUENCER(2),
        POWERADCS(3),
        TEMPADCS(4);

        int value;

        private RsetId(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }
    }

    public static enum HdwType {
        DAQ0(0),
        DAQ1(1),
        PCI0(2),
        PCI1(3);

        int value;

        private HdwType(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }
    }
}

