/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.drivers.reb;

import org.lsst.ccs.drivers.reb.ClientFactory;
import org.lsst.ccs.drivers.reb.REBException;

public class RegClient {
    public static final int HDW_TYPE_DAQ0 = 0;
    public static final int HDW_TYPE_DAQ1 = 1;
    public static final int HDW_TYPE_PCI = 2;
    public static final int HDW_TYPE_PCI0 = 2;
    public static final int HDW_TYPE_PCI1 = 3;
    Context ctxt;
    private ClientFactory clientFactory = new ClientFactory();

    public RegClient() {
        this.ctxt = new Context();
    }

    public void setClientFactory(ClientFactory clientFactory) {
        this.clientFactory = clientFactory;
    }

    protected void finalize() throws Throwable {
        super.finalize();
        if (this.ctxt.impl != null && this.ctxt.handle != 0L) {
            this.ctxt.impl.deleteRegClient(this.ctxt.handle);
        }
    }

    public void open(int id) throws REBException {
        this.open(id, null);
    }

    public void open(int id, String ifc) throws REBException {
        this.open(0, id, ifc);
    }

    public void open(int hdw, int id, String ifc) throws REBException {
        if (this.ctxt.handle != 0L) {
            throw new REBException("Register connection already open");
        }
        this.ctxt.impl = this.clientFactory.createRegClient(hdw);
        this.ctxt.handle = this.ctxt.impl.newRegClient(id, ifc);
        ++this.ctxt.instance;
    }

    public void close() throws REBException {
        this.checkOpen();
        this.ctxt.impl.deleteRegClient(this.ctxt.handle);
        this.ctxt.handle = 0L;
    }

    protected void checkOpen() throws REBException {
        if (this.ctxt.impl == null || this.ctxt.handle == 0L) {
            throw new REBException("Register connection not open");
        }
    }

    public int read(int address) throws REBException {
        this.checkOpen();
        return this.ctxt.impl.readReg(this.ctxt.handle, address);
    }

    public void read(int address, int[] values, int offset, int count) throws REBException {
        this.checkOpen();
        this.ctxt.impl.readRegs(this.ctxt.handle, address, values, offset, count);
    }

    public void read(int address, int[] values) throws REBException {
        this.checkOpen();
        this.ctxt.impl.readRegs(this.ctxt.handle, address, values, 0, values.length);
    }

    public void write(int address, int value) throws REBException {
        this.checkOpen();
        this.ctxt.impl.writeReg(this.ctxt.handle, address, value);
    }

    public void write(int address, int[] values, int offset, int count) throws REBException {
        this.checkOpen();
        this.ctxt.impl.writeRegs(this.ctxt.handle, address, values, offset, count);
    }

    public void write(int address, int[] values) throws REBException {
        this.checkOpen();
        this.ctxt.impl.writeRegs(this.ctxt.handle, address, values, 0, values.length);
    }

    public int update(int address, int mask, int value) throws REBException {
        this.checkOpen();
        return this.ctxt.impl.updateReg(this.ctxt.handle, address, mask, value);
    }

    public long readLong(int address) throws REBException {
        this.checkOpen();
        int[] vals = new int[2];
        this.ctxt.impl.readRegs(this.ctxt.handle, address, vals, 0, vals.length);
        return (long)vals[1] << 32 | (long)vals[0] & 0xFFFFFFFFL;
    }

    public void writeLong(int address, long value) throws REBException {
        this.checkOpen();
        int[] vals = new int[]{(int)value, (int)(value >> 32)};
        this.ctxt.impl.writeRegs(this.ctxt.handle, address, vals, 0, vals.length);
    }

    public static interface Impl {
        public long newRegClient(int var1, String var2);

        public void deleteRegClient(long var1);

        public int readReg(long var1, int var3) throws REBException;

        public void readRegs(long var1, int var3, int[] var4, int var5, int var6) throws REBException;

        public void writeReg(long var1, int var3, int var4) throws REBException;

        public void writeRegs(long var1, int var3, int[] var4, int var5, int var6) throws REBException;

        public int updateReg(long var1, int var3, int var4, int var5) throws REBException;
    }

    class Context {
        long handle;
        int instance;
        Impl impl;

        Context() {
        }
    }
}

