/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.drivers.reb.sim;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.Date;
import java.util.concurrent.SynchronousQueue;
import org.junit.Assert;
import org.junit.Test;
import org.lsst.ccs.drivers.reb.BaseSet;
import org.lsst.ccs.drivers.reb.ClientFactory;
import org.lsst.ccs.drivers.reb.Image;
import org.lsst.ccs.drivers.reb.ImageClient;
import org.lsst.ccs.drivers.reb.REBException;
import org.lsst.ccs.drivers.reb.RegClient;
import org.lsst.ccs.drivers.reb.TestReg;
import org.lsst.ccs.drivers.reb.sim.ClientFactorySimulation;
import org.lsst.ccs.drivers.reb.sim.SimulationException;
import org.lsst.ccs.drivers.reb.sim.TestRegSimulation;

public class TestRegSimulationTest {
    @Test
    public void testSimulation() throws REBException, InterruptedException {
        TestRegSimulation trs = new TestRegSimulation();
        trs.connect(TestReg.HdwType.DAQ1, 10, "ifcName");
        BaseSet baseSet = trs.getBaseSet();
        Assert.assertEquals((long)6L, (long)baseSet.getFwVersion());
        Date then = new Date();
        baseSet.setTime(then.getTime());
        Assert.assertEquals((long)then.getTime(), (long)baseSet.getTime());
        trs.enable(TestReg.RsetId.TIMEBASE);
        Assert.assertEquals((long)then.getTime(), (long)baseSet.convertRawTime(baseSet.readLong(12)));
        Date now = new Date();
        try {
            baseSet.setTime(now.getTime());
            Assert.fail((String)"Should not be able to setTime while TIMEBASE is enabled");
        }
        catch (SimulationException simulationException) {
            // empty catch block
        }
        Thread.sleep(10L);
        trs.disable(TestReg.RsetId.TIMEBASE);
        long time = baseSet.getTime();
        long oldTime = now.getTime();
        Assert.assertTrue((String)("Testing for " + time + " to be greater than " + oldTime), (time > oldTime ? 1 : 0) != 0);
        Thread.sleep(10L);
        Assert.assertEquals((long)time, (long)baseSet.getTime());
        Assert.assertEquals((long)time, (long)baseSet.convertRawTime(baseSet.readLong(12)));
    }

    @Test
    public void testSequencer() throws REBException, IOException, InterruptedException {
        ClientFactorySimulation factory = new ClientFactorySimulation();
        TestRegSimulation trs = new TestRegSimulation(factory);
        trs.connect(TestReg.HdwType.DAQ1, 10, "ifcName");
        trs.setTime(".");
        trs.enable(TestReg.RsetId.TIMEBASE);
        BaseSet baseSet = trs.getBaseSet();
        ImageClient imageClient = new ImageClient((RegClient)baseSet);
        imageClient.setClientFactory((ClientFactory)factory);
        imageClient.open(1, 10, "ifcName");
        SynchronousQueue imageSemaphore = new SynchronousQueue();
        imageClient.setListener(image -> {
            try {
                imageSemaphore.put(image);
            }
            catch (InterruptedException ex) {
                throw new RuntimeException("Interrupt while dealing with image", ex);
            }
        }, null);
        File tmp = File.createTempFile("slac1k", ".sif");
        tmp.deleteOnExit();
        try (InputStream resourceAsStream = TestRegSimulationTest.class.getResourceAsStream("slac1k.sif");){
            Files.copy(resourceAsStream, tmp.toPath(), StandardCopyOption.REPLACE_EXISTING);
        }
        trs.loadFile(tmp.getAbsolutePath());
        trs.enable(TestReg.RsetId.SEQUENCER);
        Image image2 = (Image)imageSemaphore.take();
        System.out.println("I got an image: " + image2);
    }
}

