/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.drivers.reb;

import org.lsst.ccs.command.annotations.Argument;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.drivers.reb.GlobalClient;
import org.lsst.ccs.drivers.reb.REBException;

public class TestGlobal {
    private final GlobalClient gbl = new GlobalClient();

    @Command(name="connect", description="Connect to a REB")
    public void connect(@Argument(name="type", description="Hardware type") HdwType type, @Argument(name="id", description="REB ID") int id) throws REBException {
        this.connect(type, id, "");
    }

    @Command(name="connect", description="Connect to a REB")
    public void connect(@Argument(name="type", description="Hardware type") HdwType type, @Argument(name="id", description="REB ID") int id, @Argument(name="ifcname", description="Network interface name") String ifcName) throws REBException {
        this.gbl.open(type.getValue(), new int[]{id}, new String[]{ifcName});
    }

    @Command(name="disconnect", description="Disconnect from a REB")
    public void disconnect() throws REBException {
        this.gbl.close();
    }

    @Command(name="acquire", description="Acquire an image")
    public void trigger(@Argument(name="name", description="Image name") String name) throws REBException {
        this.gbl.acquireImage(name);
    }

    public static enum HdwType {
        DAQ0(0),
        DAQ1(1),
        PCI(2);

        int value;

        private HdwType(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }
    }
}

