/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.drivers.reb;

import java.util.HashMap;
import java.util.Map;
import org.lsst.ccs.drivers.reb.BaseSet;
import org.lsst.ccs.drivers.reb.REBException;

public class PowerAdcs {
    public static final int REG_POWER_ADCS = 0x600000;
    public static final int NUM_POWER_REGS_S = 8;
    public static final int NUM_POWER_REGS_S5 = 10;
    public static final int NUM_POWER_REGS_W = 12;
    public static final int NUM_POWER_REGS_G = 10;
    public static final int NUM_POWER_REGS_M = 12;
    public static final int ADC_DIG_VOLTAGE = 0;
    public static final int ADC_DIG_CURRENT = 1;
    public static final int ADC_ANA_VOLTAGE = 2;
    public static final int ADC_ANA_CURRENT = 3;
    public static final int ADC_CLKH_VOLTAGE = 4;
    public static final int ADC_CLKH_CURRENT = 5;
    public static final int ADC_OD_VOLTAGE = 6;
    public static final int ADC_OD_CURRENT = 7;
    public static final int ADC_HTR_VOLTAGE = 8;
    public static final int ADC_HTR_CURRENT = 9;
    public static final int ADC_DPHI_VOLTAGE = 10;
    public static final int ADC_DPHI_CURRENT = 11;
    public static final int ADC_CLKL_VOLTAGE = 8;
    public static final int ADC_CLKL_CURRENT = 9;
    public static final int ERROR_MASK = 65536;
    public static final int VALUE_MASK = 65535;
    public static final double VOLTAGE_SCALE = 0.0015625;
    public static final double CURRENT_SCALE_LO = 1.5625E-5;
    public static final double CURRENT_SCALE_HI = 5.208333333333333E-6;
    public static final double POWER_ERROR = -8888.0;
    private static final Map<Integer, Integer> chanMapS = new HashMap<Integer, Integer>();
    private static final Map<Integer, Integer> chanMapS5;
    private static final Map<Integer, Integer> chanMapW;
    private static final Map<Integer, Integer> chanMapG;
    private static final Map<Integer, Map> chanMapMap;
    private static final Map<Integer, Integer> numRegsMap;
    BaseSet bss;

    public PowerAdcs(BaseSet bss) {
        this.bss = bss;
    }

    public void enable() throws REBException {
        this.bss.getVersion(7);
        this.bss.enable(3);
    }

    public void waitDone() throws REBException {
        this.bss.getVersion(7);
        this.bss.waitDone(3);
    }

    public long getTriggerTime() throws REBException {
        this.bss.checkNotVersion(7, 0);
        return this.bss.getTriggerTime(3);
    }

    public double readAdc(int adc) throws REBException {
        Map<Integer, Integer> chanMap = this.getChanMap();
        Integer regNum = chanMap.get(adc);
        if (regNum == null) {
            throw new REBException("Invalid power ADC number");
        }
        this.enable();
        this.waitDone();
        int value = this.bss.read(0x600000 + regNum);
        return (value & 0x10000) != 0 ? -8888.0 : this.getScale(adc) * (double)(value & 0xFFFF);
    }

    public double[] readAdcs() throws REBException {
        return this.readAdcs(0, this.getNumRegs());
    }

    public double[] readAdcs(int first, int count) throws REBException {
        if (first < 0 || count < 0 || first + count > this.getNumRegs()) {
            throw new REBException("Invalid power ADC range");
        }
        this.enable();
        this.waitDone();
        int[] rawData = new int[this.getNumRegs()];
        double[] data = new double[count];
        this.bss.read(0x600000, rawData);
        Map<Integer, Integer> chanMap = this.getChanMap();
        for (int j = 0; j < count; ++j) {
            int adc = first + j;
            int value = rawData[chanMap.get(adc)];
            data[j] = (value & 0x10000) != 0 ? -8888.0 : this.getScale(adc) * (double)(value & 0xFFFF);
        }
        return data;
    }

    public int getNumRegs() throws REBException {
        return numRegsMap.get(this.bss.getVersion(7));
    }

    private Map<Integer, Integer> getChanMap() throws REBException {
        return chanMapMap.get(this.bss.getVersion(7));
    }

    private double getScale(int adc) throws REBException {
        if ((adc & 1) == 0) {
            return 0.0015625;
        }
        if (this.bss.getVersion(7) != 2) {
            return adc <= 3 ? 1.5625E-5 : 5.208333333333333E-6;
        }
        return 1.5625E-5;
    }

    static {
        chanMapS.put(0, 0);
        chanMapS.put(1, 1);
        chanMapS.put(2, 2);
        chanMapS.put(3, 3);
        chanMapS.put(4, 4);
        chanMapS.put(5, 5);
        chanMapS.put(6, 6);
        chanMapS.put(7, 7);
        chanMapS5 = new HashMap<Integer, Integer>();
        chanMapS5.put(0, 0);
        chanMapS5.put(1, 1);
        chanMapS5.put(2, 2);
        chanMapS5.put(3, 3);
        chanMapS5.put(4, 4);
        chanMapS5.put(5, 5);
        chanMapS5.put(6, 6);
        chanMapS5.put(7, 7);
        chanMapS5.put(8, 8);
        chanMapS5.put(9, 9);
        chanMapW = new HashMap<Integer, Integer>();
        chanMapW.put(0, 0);
        chanMapW.put(1, 1);
        chanMapW.put(2, 8);
        chanMapW.put(3, 9);
        chanMapW.put(4, 2);
        chanMapW.put(5, 3);
        chanMapW.put(6, 10);
        chanMapW.put(7, 11);
        chanMapW.put(8, 6);
        chanMapW.put(9, 7);
        chanMapW.put(10, 4);
        chanMapW.put(11, 5);
        chanMapG = new HashMap<Integer, Integer>();
        chanMapG.put(0, 0);
        chanMapG.put(1, 1);
        chanMapG.put(2, 6);
        chanMapG.put(3, 7);
        chanMapG.put(4, 2);
        chanMapG.put(5, 3);
        chanMapG.put(6, 8);
        chanMapG.put(7, 9);
        chanMapG.put(8, 4);
        chanMapG.put(9, 5);
        chanMapMap = new HashMap<Integer, Map>();
        chanMapMap.put(0, chanMapS);
        chanMapMap.put(1, chanMapS);
        chanMapMap.put(2, chanMapW);
        chanMapMap.put(3, chanMapG);
        chanMapMap.put(4, chanMapS5);
        numRegsMap = new HashMap<Integer, Integer>();
        numRegsMap.put(0, 8);
        numRegsMap.put(1, 8);
        numRegsMap.put(2, 12);
        numRegsMap.put(3, 10);
        numRegsMap.put(4, 10);
    }
}

