/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.drivers.reb;

import java.nio.ByteBuffer;
import org.lsst.ccs.drivers.reb.ImageClient;
import org.lsst.ccs.drivers.reb.ImageMetadata;

public class Image
extends ImageMetadata {
    private long mdata;
    private ImageClient.Impl client;
    private ByteBuffer data;
    private static final long serialVersionUID = -7388976703992252134L;

    public Image() {
    }

    public Image(String name, long timestamp, int length, int address, long sciId, int sensorType, int stripes, int[] registers, int sciVersion, String clientVersion, String serverVersion, long event, int[] members, long mdata, ImageClient.Impl client) {
        super(name, timestamp, length, address, sciId, sensorType, stripes, registers, sciVersion, clientVersion, serverVersion, event, members);
        this.mdata = mdata;
        this.client = client;
    }

    public Image(String name, long timestamp, int length, int address, long sciId, int sensorType, int stripes, int[] registers, int sciVersion, String clientVersion, String serverVersion, long event, int[] members, ByteBuffer data) {
        super(name, timestamp, length, address, sciId, sensorType, stripes, registers, sciVersion, clientVersion, serverVersion, event, members);
        this.data = data;
    }

    @Deprecated
    public Image(long tag, int length, int format, int schema, int version, int address, int cluster, int element, long mdata, ImageClient.Impl client) {
        super(tag, length, format, schema, version, address, cluster, element);
        this.mdata = mdata;
        this.client = client;
    }

    @Deprecated
    public Image(long tag, int length, int format, int schema, int version, int address, int cluster, int element, ByteBuffer data) {
        super(tag, length, format, schema, version, address, cluster, element);
        this.data = data;
    }

    public ByteBuffer getData() {
        return this.data != null && this.data.limit() > 0 ? this.data.asReadOnlyBuffer() : null;
    }

    public ImageMetadata getMetadata() {
        return new ImageMetadata(this.name, this.timestamp, this.length, this.address, this.sciId, this.sensorType, this.stripes, this.registers, this.sciVersion, this.clientVersion, this.serverVersion, this.event, this.members);
    }

    public void deleteMetadataRef() {
        if (this.mdata != 0L) {
            this.client.deleteImageMetadataRef(this);
        }
    }

    public void finalize() throws Throwable {
        super.finalize();
        this.deleteMetadataRef();
    }
}

