package org.lsst.ccs.drivers.reb;

/**
 *  ASIC common code.
 *
 *  @author Owen Saxton
 */
public class Asic {

    /**
     *  Public constants
     */
    public static final int
        MAX_STRIPS      = 3,
        SIDE_TOP        = 0,
        SIDE_BOTTOM     = 1,
        NUM_SIDES       = 2,
        MAX_ASICS       = MAX_STRIPS * NUM_SIDES,
        ADDR_POSN       = 16,
        WRITE_POSN      = 23,
        SIDE_MASK       = 0x03,
        SIDE_POSN       = 24,
        //STRIP_MASK      = 0x07,
        STRIP_POSN      = 26;

    private static final int[] stripMaskSwap = {0, 4, 2, 6, 1, 5, 3, 7};

    /**
     *  Fields
     */
    BaseSet bss;


    /**
     *  Constructor.
     *
     *  @param  bss  The associated base set object
     */
    public Asic(BaseSet bss)
    {
        this.bss = bss;
    }


    /**
     *  Makes a command word.
     *
     *  @param  strips  The mask of strips
     *  @param  sides   The mask of sides: 1 = top; 2 = bottom
     *  @param  addr    The ASIC register address
     *  @param  write   1 to write; 0 to read
     *  @param  value   The value to write
     *  @return  The generated command word
     *  @throws  REBException 
     */
    protected int makeCommand(int strips, int sides, int addr, int write,
                              int value) throws REBException
    {
        int numStrips = bss.getNumStrips();
        if ((strips & ((1 << numStrips) - 1)) != strips) {
            throw new REBException("Invalid ASIC strips mask");
        }
        if ((sides & SIDE_MASK) != sides) {
            throw new REBException("Invalid ASIC sides mask");
        }
        //sides = sides == 2 ? 1 : sides == 1 ? 2 : sides;
        strips = numStrips == 3 ? stripMaskSwap[strips] : strips;
        return value | (addr << ADDR_POSN) | (sides << SIDE_POSN)
                 | (strips << STRIP_POSN) | (write << WRITE_POSN);
    }

}
