/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.command;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.TreeSet;
import org.lsst.ccs.command.Dictionary;
import org.lsst.ccs.command.DictionaryArgument;
import org.lsst.ccs.command.DictionaryCommand;
import org.lsst.ccs.command.DictionaryCompleter;
import org.lsst.ccs.command.TokenizedCommand;

class DefaultDictionaryCompleter
implements DictionaryCompleter,
Serializable {
    private static final long serialVersionUID = 8413764867907456999L;
    private final Dictionary dict;

    public DefaultDictionaryCompleter(Dictionary dict) {
        this.dict = dict;
    }

    @Override
    public int complete(String buffer, int index, List<CharSequence> list) {
        TreeSet<String> set;
        boolean endsWithWhiteSpace;
        TokenizedCommand tc = new TokenizedCommand(buffer.substring(0, index));
        int argCount = tc.getArgumentCount();
        boolean bl = endsWithWhiteSpace = !tc.isEmpty() && Character.isWhitespace(buffer.charAt(index - 1));
        if (endsWithWhiteSpace) {
            ++argCount;
        }
        if (tc.isEmpty()) {
            set = new TreeSet<String>();
            for (DictionaryCommand def : this.dict) {
                String command = def.getCommandName();
                command = command + " ";
                set.add(command);
                for (String alias : def.getAliases()) {
                    alias = alias + " ";
                    set.add(alias);
                }
            }
        } else {
            if (argCount == 0) {
                String prefix = tc.getCommand();
                TreeSet<String> set2 = new TreeSet<String>();
                HashSet<DictionaryCommand> uniqueCommands = new HashSet<DictionaryCommand>();
                for (DictionaryCommand def : this.dict) {
                    String command = def.getCommandName();
                    if (command.startsWith(prefix)) {
                        command = command + " ";
                        set2.add(command);
                        uniqueCommands.add(def);
                    }
                    for (String alias : def.getAliases()) {
                        if (!alias.startsWith(prefix)) continue;
                        alias = alias + " ";
                        set2.add(alias);
                        uniqueCommands.add(def);
                    }
                }
                if (set2.size() > 1 && uniqueCommands.size() == 1) {
                    list.add(((DictionaryCommand)uniqueCommands.iterator().next()).getCommandName() + " ");
                } else {
                    list.addAll(set2);
                }
                return tc.getCommandLocation();
            }
            String command = tc.getCommand();
            String lastArg = endsWithWhiteSpace ? "" : tc.getArgument(argCount - 1);
            ArrayList<String> defaultCompletions = new ArrayList<String>();
            boolean useDefaultCompletions = true;
            for (DictionaryCommand def : this.dict) {
                if (!def.matchesCommandOrAlias(command) || def.getArguments().length < argCount && !def.isVarArgs()) continue;
                int currentArgIndex = Math.min(argCount, def.getArguments().length) - 1;
                DictionaryArgument currentArg = def.getArguments()[currentArgIndex];
                boolean skipCurrentCommand = false;
                for (int i = currentArgIndex - 1; i >= 0; --i) {
                    DictionaryArgument previousArg = def.getArguments()[i];
                    if (previousArg.getAllowedValues().size() <= 0 || previousArg.getAllowedValues().contains(tc.getArgument(i))) continue;
                    skipCurrentCommand = true;
                }
                if (skipCurrentCommand) continue;
                List<String> values = currentArg.getAllowedValues();
                if (values.isEmpty()) {
                    String helpStr = "# " + currentArg.getName() + " " + currentArg.getSimpleType() + " " + currentArg.getDescription();
                    if (defaultCompletions.contains(helpStr)) continue;
                    defaultCompletions.add(helpStr);
                    continue;
                }
                useDefaultCompletions = false;
                for (String value : values) {
                    if (!DefaultDictionaryCompleter.startsWithIgnoreCase(value, lastArg) || list.contains(value = value + " ")) continue;
                    list.add(value);
                }
            }
            if (useDefaultCompletions) {
                for (String completion : defaultCompletions) {
                    list.add(completion);
                }
            }
            return endsWithWhiteSpace ? index : tc.getArgumentLocation(argCount - 1);
        }
        list.addAll(set);
        return index;
    }

    private static boolean startsWithIgnoreCase(String reference, String test) {
        if (test.length() > reference.length()) {
            return false;
        }
        return reference.substring(0, test.length()).equalsIgnoreCase(test);
    }
}

