/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.drivers.reb.sim;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.Reader;
import java.util.zip.CRC32;
import java.util.zip.CheckedOutputStream;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.lsst.ccs.drivers.reb.sim.AddressSpace;
import org.lsst.ccs.drivers.reb.sim.RegisterSet;
import org.lsst.ccs.drivers.reb.sim.SequencerSimulationTest;

public class AddressSpaceTest {
    private AddressSpace addressSpace;

    @Before
    public void setUp() {
        this.addressSpace = new AddressSpace();
    }

    @After
    public void tearDown() {
    }

    @Test
    public void testHexReadWrite() throws IOException {
        this.addressSpace.add((RegisterSet)new RegisterSet.ArrayRegisterSet(0x100000, new int[64]));
        this.addressSpace.add((RegisterSet)new RegisterSet.ArrayRegisterSet(0x200000, new int[64]));
        this.addressSpace.add((RegisterSet)new RegisterSet.ArrayRegisterSet(0x300000, new int[64]));
        try (InputStreamReader in = new InputStreamReader(SequencerSimulationTest.class.getResourceAsStream("slac1k.hex"));){
            this.addressSpace.hexLoad((Reader)in);
        }
        CRC32 crc32 = new CRC32();
        try (PrintStream out = new PrintStream(new CheckedOutputStream(System.out, crc32));){
            this.addressSpace.hexDump(out, 0, 0x400000);
            Assert.assertEquals((long)2673958955L, (long)crc32.getValue());
        }
        out = new PrintStream(new CheckedOutputStream(System.out, crc32));
        var3_5 = null;
        try {
            this.addressSpace.hexDump(out, 0x200000, 0x300000);
            Assert.assertEquals((long)4118577626L, (long)crc32.getValue());
        }
        catch (Throwable throwable) {
            var3_5 = throwable;
            throw throwable;
        }
        finally {
            if (out != null) {
                if (var3_5 != null) {
                    try {
                        out.close();
                    }
                    catch (Throwable throwable) {
                        var3_5.addSuppressed(throwable);
                    }
                } else {
                    out.close();
                }
            }
        }
    }
}

