package org.lsst.ccs.drivers.reb;

import java.io.Serializable;

/**
 ************************
 *
 *  Image metadata
 *
 *  @author Owen Saxton
 *
 ************************
 */
public class ImageMetadata implements Serializable {

    protected String name;
    protected long   timestamp;
    protected int    length;   // The number of pixels in the image data
    protected int    address;  // The address of the REB producing the image
    protected long   sciId;
    protected int    sensorType;
    protected int    stripes;
    protected int[]  registers = new int[0];
    protected int    sciVersion;  // The version of the firmware producing the image
    protected String clientVersion;
    protected String serverVersion;
    protected long   event;
    protected int[]  members = new int[0];

    @Deprecated
    protected long tag;     // The image tag
    @Deprecated
    protected int format;   // The format of the data sent from the REB
    @Deprecated
    protected int schema;   // The schema of the firmware producing the image
    @Deprecated
    protected int version;  // The version of the firmware producing the image
    @Deprecated
    protected int cluster;  // The cluster number of the RCE
    @Deprecated
    protected int element;  // The element number of the RCE
    

   /*
    *  Constructors.
    */
    public ImageMetadata() {
    }

    public ImageMetadata(String name, long timestamp, int length, int address,
                         long sciId, int sensorType, int stripes, int[] registers,
                         int sciVersion, String clientVersion, String serverVersion,
                         long event, int[] members) {
        this.name = name;
        this.timestamp = timestamp;
        this.length = length;
        this.address = address;
        this.sciId = sciId;
        this.sensorType = sensorType;
        this.stripes = stripes;
        this.registers = new int[registers.length];
        System.arraycopy(registers, 0, this.registers, 0, registers.length);
        this.sciVersion = sciVersion;
        this.clientVersion = clientVersion;
        this.serverVersion = serverVersion;
        this.event = event;
        this.members = new int[members.length];
        System.arraycopy(members, 0, this.members, 0, members.length);
    }

    @Deprecated
    public ImageMetadata(long tag, int length, int format, int schema,
                         int version, int address, int cluster, int element) {
        this.timestamp = tag;
        this.length = length;
        this.format = format;
        this.schema = schema;
        this.sciVersion = version;
        this.address = address;
        this.cluster = cluster;
        this.element = element;
    }


   /*
    *  Getters
    */
    public String getName() {
        return name;
    }

    public long getTimestamp() {
        return timestamp;
    }

    public int getLength() {
        return length;
    }

    public int getAddress() {
        return address;
    }

    public long getSciId() {
        return sciId;
    }

    public int getSensorType() {
        return sensorType;
    }

    public int getStripes() {
        return stripes;
    }

    public int[] getRegisters() {
        return registers;
    }

    public int getSciVersion() {
        return sciVersion;
    }

    public String getClientVersion() {
        return clientVersion;
    }

    public String getServerVersion() {
        return serverVersion;
    }

    public long getEvent() {
        return event;
    }

    public int[] getMembers() {
        return members;
    }

    @Deprecated
    public int getVersion() {
        return sciVersion;
    }

    @Deprecated
    public long getTag() {
        return timestamp;
    }

    @Deprecated
    public int getFormat() {
        return 0;
    }

    @Deprecated
    public int getSchema() {
        return 0;
    }

    @Deprecated
    public int getCluster() {
        return 0;
    }

    @Deprecated
    public int getElement() {
        return 0;
    }

    @Override
    public String toString()
    {
        StringBuilder text = new StringBuilder();
        text.append(String.format("Name           : %s\n", name));
        text.append(String.format("Timestamp      : %016x\n", timestamp));
        text.append(String.format("Length         : %s\n", length));
        text.append(String.format("Address        : %s\n", address));
        text.append(String.format("SCI ID         : %016x\n", sciId));
        text.append(String.format("Sensor type    : %s\n", sensorType));
        text.append(String.format("Stripes        : %s\n", stripes));
        text.append(String.format("Registers      :"));
        for (int j = 0; j < registers.length; j++) {
            text.append(String.format(" %s", registers[j]));
        }
        text.append("\n");
        text.append(String.format("SCI version    : %08x\n", sciVersion));
        text.append(String.format("Client version : %s\n", clientVersion));
        text.append(String.format("Server version : %s\n", serverVersion));
        text.append(String.format("Event          : %016x\n", event));
        text.append(String.format("Members        :"));
        for (int j = 0; j < members.length; j++) {
            text.append(String.format(" %s", members[j]));
        }
        return text.toString();
    }

    private static final long serialVersionUID = -6150031259949628403L;
}
