/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.drivers.reb;

import org.lsst.ccs.drivers.reb.ClientFactory;
import org.lsst.ccs.drivers.reb.REBException;

public class GlobalClient {
    public static final int HDW_TYPE_DAQ0 = 0;
    public static final int HDW_TYPE_DAQ1 = 1;
    public static final int HDW_TYPE_PCI0 = 2;
    public static final int HDW_TYPE_PCI1 = 3;
    public static final int HDW_TYPE_PCI = 2;
    private Impl impl;
    private ClientFactory clientFactory = new ClientFactory();

    protected void finalize() throws Throwable {
        super.finalize();
        if (this.impl != null) {
            this.impl.deleteGlobalClient();
        }
    }

    public void setClientFactory(ClientFactory clientFactory) {
        this.clientFactory = clientFactory;
    }

    public void open(int hdw, int[] ids, String[] ifcs) throws REBException {
        if (this.impl != null) {
            throw new REBException("Global connection already open");
        }
        this.impl = this.clientFactory.createGlobalClient(hdw);
        this.impl.newGlobalClient(ids, ifcs);
    }

    @Deprecated
    public void open(int hdw, int[] ids, String ifc) throws REBException {
        String[] ifcs = new String[ids.length];
        for (int j = 0; j < ifcs.length; ++j) {
            ifcs[j] = ifc;
        }
        this.open(hdw, ids, ifcs);
    }

    public void close() throws REBException {
        this.checkOpen();
        this.impl.deleteGlobalClient();
        this.impl = null;
    }

    public void setRegisterlist(int rebType, int[] registers) throws REBException {
        this.checkOpen();
        this.impl.setRegisterList(rebType, registers);
    }

    public void acquireImage(String name) throws REBException {
        this.checkOpen();
        this.impl.triggerImage(name);
    }

    private void checkOpen() throws REBException {
        if (this.impl == null) {
            throw new REBException("Global connection not open");
        }
    }

    public static interface Impl {
        default public void newGlobalClient(int[] ids, String[] ifcs) throws REBException {
        }

        @Deprecated
        default public void newGlobalClient(int[] ids, String ifcs) throws REBException {
        }

        default public void deleteGlobalClient() {
        }

        default public void setRegisterList(int rebType, int[] registers) {
        }

        default public void triggerImage(String name) throws REBException {
        }
    }
}

