/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.drivers.reb;

import org.lsst.ccs.drivers.reb.BaseSet;
import org.lsst.ccs.drivers.reb.REBException;
import org.lsst.ccs.drivers.reb.RegClient;
import org.lsst.ccs.drivers.reb.Status;

public class StatusSet
extends BaseSet {
    public static final int REG_STATUS_0 = 0x800000;
    public static final int REG_STATUS = 0xA00000;
    public static final int OFF_STAT_VERSION = 0;
    public static final int OFF_STAT_LINKSTAT = 1;
    public static final int OFF_STAT_CERR_CNT = 2;
    public static final int OFF_STAT_LDWN_CNT = 3;
    public static final int OFF_STAT_LERR_CNT = 4;
    public static final int OFF_STAT_BUFFSTAT = 5;
    public static final int OFF_STAT_RX_CNTS = 6;
    public static final int OFF_STAT_TX_CNTS = 10;
    public static final int OFF_STAT_SENT_CNT = 14;
    public static final int OFF_STAT_DISC_CNT = 15;
    public static final int OFF_STAT_TRUNC_CNT = 16;
    public static final int OFF_STAT_FORMAT = 17;
    public static final int NUM_STAT_REG = 18;
    private int baseAddr;

    public StatusSet() {
    }

    public StatusSet(RegClient reg) {
        super(reg);
    }

    @Override
    public void enable() throws REBException {
        this.enable(0);
    }

    @Override
    public void disable() throws REBException {
        this.disable(0);
    }

    public long getTriggerTime() throws REBException {
        return this.getTriggerTime(0);
    }

    public Status readStatus() throws REBException {
        int j;
        Status status = new Status();
        int[] regs = new int[18];
        this.read(this.getVersion(9) != 0 ? 0xA00000 : 0x800000, regs);
        status.version = regs[0];
        status.linkStat = regs[1];
        status.cerrCount = regs[2];
        status.ldwnCount = regs[3];
        status.lerrCount = regs[4];
        status.buffStat = regs[5];
        for (j = 0; j < status.rxCount.length; ++j) {
            status.rxCount[j] = regs[6 + j];
        }
        for (j = 0; j < status.txCount.length; ++j) {
            status.txCount[j] = regs[10 + j];
        }
        status.sentCount = regs[14];
        status.discCount = regs[15];
        status.truncCount = regs[16];
        status.format = regs[17];
        return status;
    }
}

