/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.drivers.reb;

import org.lsst.ccs.drivers.reb.BaseSet;
import org.lsst.ccs.drivers.reb.REBException;
import org.lsst.ccs.drivers.reb.RegClient;

public class FastAdcs
extends BaseSet {
    public static final int REG_FADC_COUNT = 0xC00000;
    public static final int REG_FADC_SAMPS = 0xC00010;
    public static final int NUM_FADC_SAMPS = 16;
    public static final double FADC_SCALE = 4.8828125E-4;

    public FastAdcs() {
    }

    public FastAdcs(RegClient reg) {
        super(reg);
    }

    public void enableFast() throws REBException {
        this.getVersion(12);
        this.enable(5);
    }

    public void waitFastDone() throws REBException {
        this.getVersion(12);
        this.waitDone(5);
    }

    public void setFastCount(int count) throws REBException {
        this.getVersion(12);
        this.write(0xC00000, count);
    }

    public double[][] getFast(int count) throws REBException {
        this.getVersion(12);
        this.checkFastCount(count);
        double[][] value = new double[2][count];
        double[] sValue = new double[2];
        for (int j = 0; j < count; ++j) {
            this.readFastSample(j, sValue);
            value[0][j] = sValue[0];
            value[1][j] = sValue[1];
        }
        return value;
    }

    public double[] getFastAvge(int count) throws REBException {
        this.getVersion(12);
        this.checkFastCount(count);
        double[] value = new double[]{0.0, 0.0};
        double[] sValue = new double[2];
        for (int j = 0; j < count; ++j) {
            this.readFastSample(j, sValue);
            value[0] = value[0] + sValue[0];
            value[1] = value[1] + sValue[1];
        }
        value[0] = value[0] / (double)count;
        value[1] = value[1] / (double)count;
        return value;
    }

    private void checkFastCount(int count) throws REBException {
        if (count < 0 || count >= 16) {
            throw new REBException("Invalid number of fast ADC samples");
        }
    }

    private void readFastSample(int index, double[] value) throws REBException {
        int iValue = this.read(0xC00010 + index);
        value[0] = 4.8828125E-4 * (double)(iValue << 8 >> 20 & 0xFFF);
        value[1] = 4.8828125E-4 * (double)(iValue << 20 >> 20 & 0xFFF);
    }
}

