/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.drivers.reb;

import org.lsst.ccs.drivers.reb.GlobalClient;
import org.lsst.ccs.drivers.reb.Image;
import org.lsst.ccs.drivers.reb.ImageClient;
import org.lsst.ccs.drivers.reb.REBException;
import org.lsst.ccs.drivers.reb.RegClient;

public class PciClient {
    private static boolean first = true;

    private static void loadLibrary() {
        if (first) {
            System.loadLibrary("RebPci");
            first = false;
        }
    }

    public static class Global
    implements GlobalClient.Impl {
        private int[] ids;

        @Override
        public void newGlobalClient(int[] ids, String ifc) {
            this.ids = (int[])ids.clone();
        }

        @Override
        public void deleteGlobalClient() {
        }

        @Override
        public void triggerImage(String name) {
        }
    }

    public static class Images
    implements ImageClient.Impl {
        long client;
        boolean myRegClient;
        RegClient reg;

        Images(RegClient reg) {
            PciClient.loadLibrary();
            Images.initSys();
            if (reg != null) {
                this.reg = reg;
            } else {
                this.myRegClient = true;
                this.reg = new RegClient();
            }
        }

        private static native void initSys();

        @Override
        public void newImageClient(int id, String ifc) throws REBException {
            this.newImageClient1(id, ifc);
            if (this.myRegClient) {
                try {
                    this.reg.open(2, id, ifc);
                }
                catch (REBException e) {
                    this.deleteImageClient1();
                    throw e;
                }
            }
        }

        public native void newImageClient1(int var1, String var2);

        @Override
        public void deleteImageClient() {
            if (this.myRegClient) {
                try {
                    this.reg.close();
                }
                catch (REBException rEBException) {
                    // empty catch block
                }
            }
            this.deleteImageClient1();
        }

        public native void deleteImageClient1();

        @Override
        public Image waitForImage(Image image) {
            Image newImage = this.waitForImage1(image);
            try {
                int[] values = new int[3];
                this.reg.read(0, values);
                newImage.schema = values[0];
                newImage.version = values[1];
                newImage.address = values[2];
                newImage.tag = this.reg.readLong(14);
            }
            catch (REBException rEBException) {
                // empty catch block
            }
            return newImage;
        }

        private native Image waitForImage1(Image var1);

        @Override
        public native boolean getImage(Image var1);

        @Override
        public native void reset();

        @Override
        public native void deleteImageMetadataRef(Image var1);
    }

    public static class Registers
    implements RegClient.Impl {
        Registers() {
            PciClient.loadLibrary();
        }

        @Override
        public native long newRegClient(int var1, String var2);

        @Override
        public synchronized native void deleteRegClient(long var1);

        @Override
        public int readReg(long handle, int address) throws REBException {
            int[] data = new int[1];
            this.readRegs(handle, address, data, 0, 1);
            return data[0];
        }

        @Override
        public synchronized native void readRegs(long var1, int var3, int[] var4, int var5, int var6) throws REBException;

        @Override
        public void writeReg(long handle, int address, int value) throws REBException {
            int[] data = new int[]{value};
            this.writeRegs(handle, address, data, 0, 1);
        }

        @Override
        public synchronized native void writeRegs(long var1, int var3, int[] var4, int var5, int var6) throws REBException;

        @Override
        public int updateReg(long handle, int address, int mask, int value) throws REBException {
            int oldValue = this.readReg(handle, address);
            this.writeReg(handle, address, oldValue & ~mask | value & mask);
            return oldValue;
        }
    }
}

