package org.lsst.ccs.drivers.reb.sim;

import org.lsst.ccs.drivers.reb.REBException;
import org.lsst.ccs.drivers.reb.RegClient;

/**
 * Simulated interface to DAQ1 plus REB3.
 *
 * @author Tony Johnson
 */
public class RegClientDaq1Simulation implements RegClient.Impl {

    private final HandleAndIdManager manager;

    RegClientDaq1Simulation(HandleAndIdManager manager) {
        this.manager = manager;
    }

    @Override
    public long newRegClient(int id, String ifc) {
        // Note: The IFC is not actually used in this (or any?) implementation.
        AddressSpace rs = manager.getAddressSpaceForId(id);
        return manager.allocateHandle(rs);
    }

    @Override
    public void deleteRegClient(long handle) {
        manager.freeHandle(handle);
    }

    @Override
    public synchronized int readReg(long handle, int address) throws REBException {
        int[] values = new int[1];
        readRegs1(handle, address, values, 0, 1);
        return values[0];
    }

    @Override
    public synchronized void readRegs(long handle, int address, int[] values,
            int offset, int count) throws REBException {
        readRegs1(handle, address, values, offset, count);
    }

    private void readRegs1(long handle, int address, int[] values,
            int offset, int count) throws REBException {
        AddressSpace rs = manager.getAddressSpaceForHandle(handle);
        rs.readRegs(address, values, offset, count);
    }

    @Override
    public synchronized void writeReg(long handle, int address, int value) throws REBException {
        int[] values = {value};
        writeRegs1(handle, address, values, 0, 1);
    }

    @Override
    public synchronized void writeRegs(long handle, int address, int[] values,
            int offset, int count) throws REBException {
        writeRegs1(handle, address, values, offset, count);
    }

    private void writeRegs1(long handle, int address,
            int[] values, int offset, int count) throws REBException {
        AddressSpace rs = manager.getAddressSpaceForHandle(handle);
        rs.writeRegs(address, values, offset, count);
    }

    @Override
    public synchronized int updateReg(long handle, int address, int mask,
            int value) throws REBException {
        int[] values = {0};
        readRegs1(handle, address, values, 0, 1);
        int oldVal = values[0];
        values[0] = (values[0] & ~mask) | (value & mask);
        writeRegs1(handle, address, values, 0, 1);
        return oldVal;
    }
}
