package org.lsst.ccs.drivers.reb.sim;

import java.util.ArrayList;
import java.util.List;
import org.lsst.ccs.drivers.reb.BaseSet;
import org.lsst.ccs.drivers.reb.GlobalClient;
import org.lsst.ccs.drivers.reb.REBException;

/**
 * A simulation of the DAQ v1 GlobalClient
 *
 * @author tonyj
 */
public class GlobalClientSimulation implements GlobalClient.Impl {

    private final HandleAndIdManager manager;
    private List<AddressSpace> addressSpaces;

    GlobalClientSimulation(HandleAndIdManager manager) {
        this.manager = manager;
    }

    @Override
    public void triggerImage(String name) {
        if (addressSpaces == null) {
            throw new SimulationException("triggerImage called but no ids registered");
        }
        // FIXME: Name is ignored for now
        for (AddressSpace as : addressSpaces) {
            // FIXME: We should have some lock around this, or a better way of triggering
            int state = as.read(BaseSet.REG_STATE);
            state |= 1<<BaseSet.RSET_SEQUENCER;
            as.write(BaseSet.REG_TRIGGER, state);
        }
    }

    @Override
    public void deleteGlobalClient() {
        addressSpaces = null;
    }

    @Override
    public void newGlobalClient(int[] ids, String ifc) throws REBException {
        if (addressSpaces != null) {
            throw new SimulationException("Unsupported repeat call to newGlobalClient");
        }
        List<AddressSpace> seqs = new ArrayList<>();
        // Locate the sequencers with the given ids.
        for (int id : ids) {
            AddressSpace as = manager.getAddressSpaceForId(id);
            seqs.add(as);
        }
        this.addressSpaces = seqs;
    }
}
