package org.lsst.ccs.drivers.reb;

/**
 ******************************************************************************
 **
 **  REB status block.
 **
 **  @author Owen Saxton
 **
 ******************************************************************************
 */
public class Status {

   /**
    ***************************************************************************
    **
    **  Package fields.
    **
    ***************************************************************************
    */
    int version;
    int linkStat;
    int cerrCount;
    int ldwnCount;
    int lerrCount;
    int buffStat;
    int[] rxCount = new int[4];
    int[] txCount = new int[4];
    int sentCount;
    int discCount;
    int truncCount;
    int format;


   /**
    ***************************************************************************
    **
    **  Gets the version.
    **
    **  @return  The version
    **
    ***************************************************************************
    */
    public int getVersion()
    {
        return version;
    }


   /**
    ***************************************************************************
    **
    **  Gets the PGP link status.
    **
    **  @return  The link status
    **
    ***************************************************************************
    */
    public int getLinkStatus()
    {
        return linkStat;
    }


   /**
    ***************************************************************************
    **
    **  Gets the PGP cell error count.
    **
    **  @return  The cell error count
    **
    ***************************************************************************
    */
    public int getCellErrorCount()
    {
        return cerrCount;
    }


   /**
    ***************************************************************************
    **
    **  Gets the PGP link down count.
    **
    **  @return  The link down count
    **
    ***************************************************************************
    */
    public int getLinkDownCount()
    {
        return ldwnCount;
    }


   /**
    ***************************************************************************
    **
    **  Gets the PGP link error count.
    **
    **  @return  The link error count
    **
    ***************************************************************************
    */
    public int getLinkErrorCount()
    {
        return lerrCount;
    }


   /**
    ***************************************************************************
    **
    **  Gets the PGP VC buffer status.
    **
    **  @return  The buffer status
    **
    ***************************************************************************
    */
    public int getVcBufferStatus()
    {
        return buffStat;
    }


   /**
    ***************************************************************************
    **
    **  Gets the PGP VC receive counters.
    **
    **  @return  The array of receive counts
    **
    ***************************************************************************
    */
    public int[] getVcRxCounts()
    {
        return rxCount;
    }


   /**
    ***************************************************************************
    **
    **  Gets the PGP VC transmit counters.
    **
    **  @return  The array of transmit counts
    **
    ***************************************************************************
    */
    public int[] getVcTxCounts()
    {
        return txCount;
    }


   /**
    ***************************************************************************
    **
    **  Gets the sent images counter.
    **
    **  @return  The counter value
    **
    ***************************************************************************
    */
    public int getSentCount()
    {
        return sentCount;
    }


   /**
    ***************************************************************************
    **
    **  Gets the discarded images counter.
    **
    **  @return  The counter value
    **
    ***************************************************************************
    */
    public int getDiscCount()
    {
        return discCount;
    }


   /**
    ***************************************************************************
    **
    **  Gets the truncated images counter.
    **
    **  @return  The counter value
    **
    ***************************************************************************
    */
    public int getTruncCount()
    {
        return truncCount;
    }


   /**
    ***************************************************************************
    **
    **  Gets the image data format.
    **
    **  @return  The data format: 0 = unknowm; 1 = 32-bit; 2 = 16-bit
    **
    ***************************************************************************
    */
    public int getFormat()
    {
        return format;
    }

}
