package org.lsst.ccs.drivers.reb;

//import java.util.HashMap;
//import java.util.Map;

/**
 ******************************************************************************
 **
 **  Java interface to the REB via the PGP PCI card.
 **
 **  @author Owen Saxton
 **
 ******************************************************************************
 */
public class PciClient {

    //private static Map<Integer, Registers> idMap = new HashMap<>();

    private static boolean first = true;

    private static void loadLibrary() {
        if (first) {
            System.loadLibrary("RebPci");
            first = false;
        }
    }

   /**
     **************************************************************************
     **
     **  Register interface.
     **
     **************************************************************************
     */
    public static class Registers implements RegClient.Impl {

        Registers() {
            loadLibrary();
        }

        @Override
        //public long newRegClient(int id, String ifc) {
        //    long handle = newRegClient1(id, ifc);
        //    idMap.put(id, this);
        //    return handle;
        //}

        public native long newRegClient(int id, String ifc);

        @Override
        public synchronized native void deleteRegClient(long handle);

        @Override
        public int readReg(long handle, int address) throws REBException {
            int[] data = new int[1];
            readRegs(handle, address, data, 0, 1);
            return data[0];
        }

        @Override
        public synchronized native void readRegs(long handle, int address,
                                                 int[] values, int offset,
                                                 int count) throws REBException;

        @Override
        public void writeReg(long handle, int address, int value)
            throws REBException {
            int[] data = {value};
            writeRegs(handle, address, data, 0, 1);
        }

        @Override
        public synchronized native void writeRegs(long handle, int address,
                                                  int[] values, int offset,
                                                  int count) throws REBException;

        @Override
        public int updateReg(long handle, int address, int mask, int value)
            throws REBException {
            int oldValue = readReg(handle, address);
            writeReg(handle, address, (oldValue & ~mask) | (value & mask));
            return oldValue;
        }

    }

   /**
     **************************************************************************
     **
     **  Image interface.
     **
     **************************************************************************
     */
    public static class Images implements ImageClient.Impl  {

        long client;
        boolean myRegClient;
        RegClient reg;

        Images(RegClient reg) {
            loadLibrary();
            initSys();
            if (reg != null) {
                this.reg = reg;
            }
            else {
                myRegClient = true;
                this.reg = new RegClient();
            }
        }

        private native static void initSys();

        @Override
        public void newImageClient(int id, String ifc) throws REBException {
            newImageClient1(id, ifc);
            if (myRegClient) {
                try {
                   reg.open(RegClient.HDW_TYPE_PCI, id, ifc);
                }
                catch (REBException e) {
                    deleteImageClient1();
                    throw e;
                }
            }
        }

        public native void newImageClient1(int id, String ifc);

        @Override
        public void deleteImageClient() {
            if (myRegClient) {
                try {
                    reg.close();
                }
                catch (REBException e) {
                }
            }
            deleteImageClient1();
        }

        public native void deleteImageClient1();

        @Override
        public Image waitForImage(Image image) {
            Image newImage = waitForImage1(image);
            try {
                int[] values = new int[3];
                reg.read(BaseSet.REG_SCHEMA, values);
                newImage.schema = values[0];
                newImage.version = values[1];
                newImage.address = values[2];
                newImage.tag = reg.readLong(BaseSet.REG_TRIG_TIME
                                              + 2 * BaseSet.RSET_SEQUENCER);
            }
            catch (REBException e) {
            }
            return newImage;
        }

        private native Image waitForImage1(Image image);

        @Override
        public native boolean getImage(Image image);

        @Override
        public native void reset();

        @Override
        public native void deleteImageMetadataRef(Image image);
        
    }

   /**
     **************************************************************************
     **
     **  Global interface.
     **
     **************************************************************************
     */
    public static class Global implements GlobalClient.Impl  {

        private int[] ids;

        @Override
        public void newGlobalClient(int[] ids, String ifc) {
            this.ids = ids.clone();
        }

        @Override
        public void deleteGlobalClient() {
        }

        @Override
        public void triggerImage(String name) {
            
        }

    }

}