/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.drivers.reb;

import java.util.HashMap;
import java.util.Map;
import org.lsst.ccs.command.annotations.Argument;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.drivers.reb.REBException;
import org.lsst.ccs.drivers.reb.TempRtds;
import org.lsst.ccs.drivers.reb.TestReg;

public class TestRtds
extends TestReg {
    private static final Map<Integer, String> chanValues = new HashMap<Integer, String>();
    private static final Map<Integer, String> cnvModeValues;
    private static final Map<Integer, String> rateValues;
    private static final Map<Integer, String> clockValues;
    private static final Map<Integer, String> gainValues;
    private static final Map<Integer, String> refsValues;
    private static final Map<Integer, String> calibValues;
    private final TempRtds ad;
    private static final String[] regName;
    private static final String[] regDesc0;
    private static final String[] regDesc1;

    public TestRtds() {
        this.ad = this.rtd;
    }

    @Command(name="initialize", description="Initialize the chip")
    public void initialize() throws REBException {
        this.ad.reset();
        this.ad.setupStandard();
    }

    @Command(name="showstatus", description="Show the status register")
    public String showStatReg() throws REBException {
        int status = this.ad.getStatus();
        return String.format("Status: %sready, %serror, %sextref, %s, chan = %s", (status & 0x80) == 0 ? "" : "not ", (status & 0x40) != 0 ? "" : "no ", (status & 0x20) == 0 ? "" : "no ", (status & 8) != 0 ? "AD7794" : "AD7795", chanValues.get(status & 7));
    }

    @Command(name="setchannel", description="Set the channel")
    public void setChan(@Argument(name="chan", description="Channel name") ChanNames chan) throws REBException {
        this.ad.setChannel(chan.getValue());
    }

    @Command(name="showchannel", description="Show the channel")
    public String showChan() throws REBException {
        int chan = this.ad.getChannel();
        return String.format("Channel = %s (%s)", chan, chanValues.get(chan));
    }

    @Command(name="setconversion", description="Set the conversion mode")
    public void setConv(@Argument(name="mode", description="Conversion mode") CnvModeNames mode) throws REBException {
        this.ad.setConvMode(mode.getValue());
    }

    @Command(name="showconversion", description="Show the conversion mode")
    public String showConv() throws REBException {
        int mode = this.ad.getConvMode();
        return String.format("Conversion mode = %s (%s)", mode, cnvModeValues.get(mode));
    }

    @Command(name="setrate", description="Set the conversion rate")
    public void setRate(@Argument(name="rate", description="Conversion rate") RateNames rate) throws REBException {
        this.ad.setConvRate(rate.getValue());
    }

    @Command(name="showrate", description="Show the conversion rate")
    public String showRate() throws REBException {
        int rate = this.ad.getConvRate();
        return String.format("Conversion rate = %s (%s)", rate, rateValues.get(rate).substring(1) + " Hz");
    }

    @Command(name="setclock", description="Set the clock source")
    public void setClock(@Argument(name="clock", description="Clock source") ClockNames clock) throws REBException {
        this.ad.setClockSource(clock.getValue());
    }

    @Command(name="showclock", description="Show the clock source")
    public String showClock() throws REBException {
        int clock = this.ad.getClockSource();
        return String.format("Clock source = %s (%s)", clock, clockValues.get(clock));
    }

    @Command(name="setgain", description="Set the gain")
    public void setGain(@Argument(name="gain", description="The gain name") GainNames gain) throws REBException {
        this.ad.setGain(gain.getValue());
    }

    @Command(name="showgain", description="Show the gain")
    public String showGain() throws REBException {
        int gain = this.ad.getGain();
        return String.format("ADC gain = %s (%sx)", gain, gainValues.get(gain).substring(1));
    }

    @Command(name="setreference", description="Set the reference source")
    public void setReference(@Argument(name="source", description="Reference source") RefsNames source) throws REBException {
        this.ad.setRefSelect(source.getValue());
    }

    @Command(name="showreference", description="Show the reference source")
    public String showRefsel() throws REBException {
        int refs = this.ad.getRefSelect();
        return String.format("Reference source = %s (%s)", refs, refsValues.get(refs));
    }

    @Command(name="setrefdet", description="Set reference detection")
    public void setRefdet(@Argument(name="state", description="State to set") TestReg.OnOff det) throws REBException {
        this.ad.setRefDetect(det == TestReg.OnOff.ON);
    }

    @Command(name="showrefdet", description="Show reference detection state")
    public String showRefdet() throws REBException {
        return String.format("Reference detection is %s", TestRtds.onOff(this.ad.isRefDetect()));
    }

    @Command(name="setbuffered", description="Set buffered mode state")
    public void setBuff(@Argument(name="state", description="State to set") TestReg.OnOff on) throws REBException {
        this.ad.setBuffered(on == TestReg.OnOff.ON);
    }

    @Command(name="showbuffered", description="Show buffered mode state")
    public String showBuff() throws REBException {
        return String.format("Buffered mode is %s", TestRtds.onOff(this.ad.isBuffered()));
    }

    @Command(name="setunipolar", description="Set unipolar state")
    public void setUnipol(@Argument(name="state", description="State to set") TestReg.OnOff on) throws REBException {
        this.ad.setUnipolar(on == TestReg.OnOff.ON);
    }

    @Command(name="showunipolar", description="Shoe unipolar state")
    public String showUnipol() throws REBException {
        return String.format("Unipolar mode is %s", TestRtds.onOff(this.ad.isUnipolar()));
    }

    @Command(name="setswitch", description="Set the power switch")
    public void setSwitch(@Argument(name="state", description="Switch state") TestReg.OnOff on) throws REBException {
        this.ad.setPowerSwitch(on == TestReg.OnOff.ON);
    }

    @Command(name="showswitch", description="Show the power switch")
    public String showSwitch() throws REBException {
        return String.format("Power switch is %s", TestRtds.onOff(this.ad.isPowerSwitch()));
    }

    @Command(name="readadc", description="Read an ADC")
    public String readAdc(@Argument(name="chan", description="Channel number") int chan, @Argument(name="count", description="Sample count") int count, OptionNames ... optns) throws REBException {
        int option = this.getOption(optns);
        double sum = 0.0;
        double sumsq = 0.0;
        for (int j = 0; j < count; ++j) {
            double value = this.ad.readAdc(chan, option);
            sum += value;
            sumsq += value * value;
        }
        return TestRtds.showStats("Raw " + chanValues.get(chan), count, sum, sumsq);
    }

    @Command(name="readtemp", description="Read the chip temperature")
    public String readTemp(@Argument(name="count", description="Sample count") int count, OptionNames ... optns) throws REBException {
        int option = this.getOption(optns);
        double sum = 0.0;
        double sumsq = 0.0;
        for (int j = 0; j < count; ++j) {
            double value = this.ad.readTemperature(option);
            sum += value;
            sumsq += value * value;
        }
        return TestRtds.showStats("Temperature", count, sum, sumsq);
    }

    @Command(name="readvdd", description="Read the chip VDD")
    public String ReadVdd(@Argument(name="count", description="Sample count") int count, OptionNames ... optns) throws REBException {
        int option = this.getOption(optns);
        double sum = 0.0;
        double sumsq = 0.0;
        for (int j = 0; j < count; ++j) {
            double value = this.ad.readVdd(option);
            sum += value;
            sumsq += value * value;
        }
        return TestRtds.showStats("Voltage", count, sum, sumsq);
    }

    @Command(name="calibrate", description="Perform a calibration")
    public String calibrate(@Argument(name="chan", description="Channel number") int chan, @Argument(name="type", description="Calibration type") int type) throws REBException {
        int value = this.ad.calibrate(chan, type);
        return String.format("New %s value = %s", (type & 1) == 0 ? "offset" : "scale", value);
    }

    @Command(name="showcalib", description="Show calibration values")
    public String showCalib(@Argument(name="chan", description="Channel number") int chan) throws REBException {
        int[] value = this.ad.getCalibration(chan);
        return String.format("Offset = %s, scale = %s", value[0], value[1]);
    }

    @Command(name="showregs", description="Show all register values")
    public String showRegs() throws REBException {
        StringBuilder st = new StringBuilder();
        int[] regSize = this.ad.getRegSizes();
        for (int j = 0; j < 8; ++j) {
            int value = this.ad.readRegister(j);
            int size = 2 * regSize[j];
            String fmt = String.format("%%d (%%s): %%s%%0%sx  %%s", size);
            if (j > 0) {
                st.append('\n');
            }
            st.append(String.format(fmt, j, regName[j], "      ".substring(size), value, regDesc0[j]));
            if (regDesc1[j].isEmpty()) continue;
            st.append(String.format("\n                  %s", regDesc1[j]));
        }
        return st.toString();
    }

    @Command(name="readregister", description="Read a register")
    public String readReg(@Argument(name="regnum", description="Register number") int regnum) throws REBException {
        String fmt = String.format("Register %%s: %%0%sx", 2 * this.ad.getRegSizes()[regnum &= 7]);
        return String.format(fmt, regnum, this.ad.readRegister(regnum));
    }

    @Command(name="writeregister", description="Write a register")
    public void writeReg(@Argument(name="regnum", description="Register number") int regnum, @Argument(name="value", description="Value to write") int value) throws REBException {
        this.ad.writeRegister(regnum, value);
    }

    @Command(name="setdelay", description="Set read and write delays")
    public void setDelay(@Argument(name="rdelay", description="Read delay (ms)") int rDelay, @Argument(name="wdelay", description="Write delay (ms)") int wDelay) throws REBException {
        this.ad.setDelay(rDelay, wDelay);
    }

    @Command(name="setdebug", description="Set debug state on or off")
    public void setDelay(@Argument(name="state", description="Debug state") TestReg.OnOff state) throws REBException {
        this.ad.setDebug(state == TestReg.OnOff.ON);
    }

    private int getOption(OptionNames[] optns) {
        int option = 0;
        for (OptionNames optn : optns) {
            option |= optn.getValue();
        }
        return option;
    }

    private static String showStats(String name, int count, double sum, double sumsq) {
        double mean = sum / (double)count;
        double sigsq = sumsq / (double)count - mean * mean;
        double sigma = sigsq <= 0.0 ? 0.0 : Math.sqrt(sigsq);
        return String.format("%s: mean = %.7g, sigma = %.7g", name, mean, sigma);
    }

    private static String onOff(boolean on) {
        return on ? "on" : "off";
    }

    static {
        for (ChanNames chanNames : ChanNames.values()) {
            chanValues.put(chanNames.getValue(), chanNames.name().toLowerCase());
        }
        cnvModeValues = new HashMap<Integer, String>();
        for (Enum enum_ : CnvModeNames.values()) {
            cnvModeValues.put(((CnvModeNames)enum_).getValue(), enum_.name().toLowerCase());
        }
        rateValues = new HashMap<Integer, String>();
        for (Enum enum_ : RateNames.values()) {
            rateValues.put(((RateNames)enum_).getValue(), enum_.name().toLowerCase());
        }
        clockValues = new HashMap<Integer, String>();
        for (Enum enum_ : ClockNames.values()) {
            clockValues.put(((ClockNames)enum_).getValue(), enum_.name().toLowerCase());
        }
        gainValues = new HashMap<Integer, String>();
        for (Enum enum_ : GainNames.values()) {
            gainValues.put(((GainNames)enum_).getValue(), enum_.name().toLowerCase());
        }
        refsValues = new HashMap<Integer, String>();
        for (Enum enum_ : RefsNames.values()) {
            refsValues.put(((RefsNames)enum_).getValue(), enum_.name().toLowerCase());
        }
        calibValues = new HashMap<Integer, String>();
        for (Enum enum_ : CalibNames.values()) {
            calibValues.put(((CalibNames)enum_).getValue(), enum_.name().toLowerCase());
        }
        regName = new String[]{"STAT", "MODE", "CONF", "DATA", " ID ", " IO ", "OFFS", "FSCL"};
        regDesc0 = new String[]{"| ~RDY |  ERR |NOXREF|  --  | 7794 | CHAN2| CHAN1| CHAN0|", "| MOD2 | MOD1 | MOD0 |  PSW |  --  |  --  |AMPCOM|  --  |", "|VBIAS1|VBIAS0|BRNOUT|UNIPOL| BOOST| GAIN2| GAIN1| GAIN0|", "", "", "|  --  |DIOENA|IODAT2|IODAT1|CSDIR1|CSDIR0|CSENA1|CSENA0|", "", ""};
        regDesc1 = new String[]{"", "| CLK1 | CLK0 |  --  |CHPDIS| FRS3 | FRS2 | FRS1 | FRS0 |", "|RFSEL1|RFSEL0|REFDET|BUFFRD| CHAN3| CHAN2| CHAN1| CHAN0|", "", "", "", "", ""};
    }

    public static enum OptionNames {
        CONFIG(1),
        SINGLE(2),
        IMMED(4);

        private final int value;

        private OptionNames(int value) {
            this.value = value;
        }

        int getValue() {
            return this.value;
        }
    }

    public static enum CalibNames {
        INTOFF(0),
        INTGAIN(1),
        EXTOFF(2),
        EXTGAIN(3);

        private final int value;

        private CalibNames(int value) {
            this.value = value;
        }

        int getValue() {
            return this.value;
        }
    }

    public static enum RefsNames {
        EXT1(0),
        EXT2(1),
        INTERNAL(2);

        private final int value;

        private RefsNames(int value) {
            this.value = value;
        }

        int getValue() {
            return this.value;
        }
    }

    public static enum GainNames {
        X1(0),
        X2(1),
        X4(2),
        X8(3),
        X16(4),
        X32(5),
        X64(6),
        X128(7);

        private final int value;

        private GainNames(int value) {
            this.value = value;
        }

        int getValue() {
            return this.value;
        }
    }

    public static enum ClockNames {
        INTERNAL(0),
        INTAVAIL(1),
        EXTERNAL(2),
        EXTHALF(3);

        private final int value;

        private ClockNames(int value) {
            this.value = value;
        }

        int getValue() {
            return this.value;
        }
    }

    public static enum RateNames {
        R470(1),
        R242(2),
        R123(3),
        R62(4),
        R50(5),
        R39(6),
        R33(7),
        R19(8),
        R17(9),
        R16(10),
        R12(11),
        R10(12),
        R8(13),
        R6(14),
        R4(15);

        private final int value;

        private RateNames(int value) {
            this.value = value;
        }

        int getValue() {
            return this.value;
        }
    }

    public static enum CnvModeNames {
        CONTINUOUS(0),
        SINGLE(1),
        IDLE(2),
        POWERDOWN(3),
        INTOFFCAL(4),
        INTGAINCAL(5),
        EXTOFFCAL(6),
        EXTGAINCAL(7);

        private final int value;

        private CnvModeNames(int value) {
            this.value = value;
        }

        int getValue() {
            return this.value;
        }
    }

    public static enum ChanNames {
        AIN1(0),
        AIN2(1),
        AIN3(2),
        AIN4(3),
        AIN5(4),
        AIN6(5),
        TEMP(6),
        VDD(7);

        private final int value;

        private ChanNames(int value) {
            this.value = value;
        }

        int getValue() {
            return this.value;
        }
    }
}

