/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.drivers.reb;

import java.util.HashMap;
import java.util.Map;
import org.lsst.ccs.drivers.reb.BaseSet;
import org.lsst.ccs.drivers.reb.REBException;
import org.lsst.ccs.drivers.reb.RegClient;

public class SlowAdcs
extends BaseSet {
    public static final int VERSION_WGREB1 = 0;
    public static final int VERSION_WGREB2 = 2;
    public static final int VERSION_REB3 = 1;
    public static final int VERSION_REB4 = 3;
    public static final int REG_TEMP_SLCT = 0x600100;
    public static final int REG_TEMP_READ = 0x600101;
    public static final int REG_TEMP_MUX = 0x600200;
    public static final int TEMP_CABAC_TOP = 0;
    public static final int TEMP_CABAC_BOTTOM = 1;
    public static final int TEMP_ASPIC_TOP = 2;
    public static final int TEMP_ASPIC_BOTTOM = 3;
    public static final int NUM_TEMPS = 4;
    public static final int MUX_T_B_SLOW = 0;
    public static final int MUX_T_FAST_B_SLOW = 1;
    public static final int MUX_T_SLOW_B_FAST = 2;
    public static final int MUX_T_B_FAST = 3;
    public static final int NUM_MUX_SET = 4;
    public static final int REG_ASPIC_START = 0x600100;
    public static final int REG_ASPIC_READ = 0x601000;
    public static final int REG_MUX_CONFIG = 0x600101;
    public static final int REG_MUX_READ = 0x601010;
    public static final int NUM_ASPIC_TEMPS = 6;
    public static final int NUM_CURR_CHANS = 8;
    public static final int REG_MON_START = 0xC00000;
    public static final int REG_MON_CONFIG = 0xC00001;
    public static final int REG_MON_READ = 0xC00010;
    public static final int OFF_MON_ADCS = 256;
    public static final int NUM_MON_ADCS = 2;
    public static final int OFF_MON_OD = 0;
    public static final int OFF_MON_GD = 1;
    public static final int OFF_MON_OG = 2;
    public static final int OFF_MON_RD = 3;
    public static final int OFF_MON_CKP = 4;
    public static final int OFF_MON_CKS = 5;
    public static final int OFF_MON_RG = 6;
    public static final int OFF_MON_VREF25 = 7;
    public static final int OFF_MON_SCK_L = 0;
    public static final int OFF_MON_SCK_U = 1;
    public static final int OFF_MON_RG_L = 2;
    public static final int OFF_MON_RG_U = 3;
    public static final int OFF_MON_CKP_SH = 4;
    public static final int OFF_MON_I_OD = 5;
    public static final int CHAN_OD_0 = 0;
    public static final int CHAN_OG_0 = 1;
    public static final int CHAN_RD_0 = 2;
    public static final int CHAN_GD_0 = 3;
    public static final int CHAN_OD_1 = 4;
    public static final int CHAN_OG_1 = 5;
    public static final int CHAN_RD_1 = 6;
    public static final int CHAN_GD_1 = 7;
    public static final int CHAN_OD_2 = 8;
    public static final int CHAN_OG_2 = 9;
    public static final int CHAN_RD_2 = 10;
    public static final int CHAN_GD_2 = 11;
    public static final int CHAN_VREF5_0 = 12;
    public static final int CHAN_VREF5_1 = 13;
    public static final int CHAN_VREF5_2 = 14;
    public static final int CHAN_VREF25_1 = 15;
    public static final int CHAN_OD = 16;
    public static final int CHAN_OG = 17;
    public static final int CHAN_RD = 18;
    public static final int CHAN_GD = 19;
    public static final int CHAN_VREF25 = 20;
    public static final int CHAN_CKP = 21;
    public static final int CHAN_CKS = 22;
    public static final int CHAN_RG = 23;
    public static final int CHAN_SCK_L = 24;
    public static final int CHAN_SCK_U = 25;
    public static final int CHAN_RG_L = 26;
    public static final int CHAN_RG_U = 27;
    public static final int CHAN_CKP_SH = 28;
    public static final int CHAN_I_OD = 29;
    public static final int CHAN_CKP_L = 30;
    public static final int CHAN_CKP_U = 31;
    public static final int CHAN_VP12 = 32;
    public static final int CHAN_VN12 = 33;
    public static final double VOLT_16_SCALE_0 = 2.288818359375E-5;
    public static final double VOLT_12_SCALE = 0.001220703125;
    public static final double VOLT_12_SCALE_HI = 0.013427734375;
    public static final double VOLT_16_SCALE = 1.52587890625E-4;
    public static final double VOLT_16_SCALE_MD = 6.103515625E-4;
    public static final double VOLT_16_SCALE_HI = 0.001678466796875;
    public static final double CURR_16_SCALE_OD = 2.5431315104166665E-6;
    public static final double CURR_12_SCALE = 1.220703125E-6;
    public static final double CURR_16_SCALE = 1.52587890625E-7;
    public static final double TEMP_OFFSET = 442.32142857142856;
    public static final double TEMP_12_SCALE = -0.21798270089285715;
    public static final double TEMP_16_SCALE = -0.027247837611607144;
    private static final int[] voltsCfgReb3 = new int[]{60, 92, 124, 28, 156, 220, 252, 29, 188, 61, 93, 157, 189, 221, 125, 253};
    private static final double[] voltsScaleReb3 = new double[]{0.013427734375, 0.013427734375, 0.013427734375, 0.013427734375, 0.001220703125, 0.013427734375, 0.013427734375, 0.013427734375, 0.013427734375, 0.001220703125, 0.001220703125, 0.013427734375, 0.013427734375, 0.013427734375, 0.013427734375, 0.001220703125};
    private static final Map<Integer, Integer> chanMapReb3 = new HashMap<Integer, Integer>();
    private static final int[] voltsCfgReb4;
    private static final double[] voltsScaleReb4;
    private static final Map<Integer, Integer> chanMapReb4;
    private static final double[][] voltsScaleWgreb2;
    private static final Map<Integer, Integer> chanMapWgreb2;

    public SlowAdcs() {
    }

    public SlowAdcs(RegClient reg) {
        super(reg);
    }

    public int readDirect(int config) throws REBException {
        this.checkVersion(11, 1, 3);
        this.write(0x600101, config);
        return this.read(0x601010) & 0xFFFF;
    }

    public double[] readAspicTemps(int first, int count) throws REBException {
        this.checkVersion(11, 1, 3);
        if (first < 0 || count < 0 || first + count > 6) {
            throw new REBException("Invalid ASPIC temperature range");
        }
        int version = this.getVersion(11);
        double[] data = new double[count];
        this.write(0x600100, 0);
        for (int j = 0; j < count; ++j) {
            int value = this.read(0x601000 + first + j);
            data[j] = version == 1 ? 442.32142857142856 + -0.21798270089285715 * (double)(value & 0xFFF) : 442.32142857142856 + -0.027247837611607144 * (double)(value & 0xFFFF);
        }
        return data;
    }

    public double readAspicTemp(int strip, int side) throws REBException {
        this.checkVersion(11, 1, 3);
        SlowAdcs.checkStrip(strip);
        SlowAdcs.checkSide(side);
        if (this.getVersion(11) == 1) {
            this.write(0x600101, 4 * strip + side + 2);
            return 442.32142857142856 + (double)(this.read(0x601010) & 0xFFF) * -0.21798270089285715;
        }
        int samChan = 4 * strip + side + 2;
        this.setMuxReb4(0, samChan & 7, (samChan >> 3) + 1, 1);
        return 442.32142857142856 + (double)(this.read(0x601010) & 0xFFFF) * -0.027247837611607144;
    }

    public double readVoltage(int chan) throws REBException {
        this.checkVersion(11, 1, 3, 2);
        int version = this.getVersion(11);
        Map<Integer, Integer> chanMap = version == 1 ? chanMapReb3 : (version == 3 ? chanMapReb4 : chanMapWgreb2);
        Integer desc = chanMap.get(chan);
        if (desc == null) {
            throw new REBException("Invalid voltage channel: " + chan);
        }
        if (version == 1) {
            this.write(0x600101, voltsCfgReb3[desc]);
            return (double)(this.read(0x601010) & 0xFFF) * voltsScaleReb3[desc];
        }
        if (version == 3) {
            int cfg = voltsCfgReb4[desc];
            this.setMuxReb4(cfg >> 12, cfg >> 8 & 0xF, cfg >> 4 & 0xF, cfg & 0xF);
            return (double)(this.read(0x601010) & 0xFFFF) * voltsScaleReb4[desc];
        }
        int adc = desc >> 4;
        int ch = desc & 0xF;
        int rawValue = this.read(0xC00010 + adc * 256 + ch) & 0xFFFF;
        return (double)(rawValue - 32768) * voltsScaleWgreb2[adc][ch];
    }

    public double readCurrent(int strip, int side, int chan) throws REBException {
        this.checkVersion(11, 1, 3);
        SlowAdcs.checkStrip(strip);
        SlowAdcs.checkSide(side);
        if (chan < 0 || chan >= 8) {
            throw new REBException("Invalid current channel: " + chan);
        }
        if (this.getVersion(11) == 1) {
            this.write(0x600101, 4 * strip + side | chan << 5 | 0x10);
            return (double)(this.read(0x601010) & 0xFFF) * 1.220703125E-6;
        }
        int samChan = 4 * strip + side;
        this.setMuxReb4(chan, samChan & 7, (samChan >> 3) + 1, 1);
        return (double)(this.read(0x601010) & 0xFFFF) * 1.52587890625E-7;
    }

    public double readCurrent(int chan) throws REBException {
        return this.readCurrent(chan >> 4, chan >> 3 & 1, chan & 7);
    }

    public void fetchVoltages(int mask) throws REBException {
        this.checkVersion(11, 2);
        for (int j = 0; j < 2; ++j) {
            if ((mask & 1 << j) == 0) continue;
            this.write(0xC00000 + j * 256, 0);
        }
    }

    public void configure(int adc, int value) throws REBException {
        this.checkVersion(11, 2);
        SlowAdcs.checkAdc(adc);
        this.write(0xC00001 + adc * 256, value);
    }

    public double readSlow(int chan) throws REBException {
        this.checkVersion(11, 0);
        if (chan < 0 || chan >= 4) {
            throw new REBException("Invalid slow ADC channel number");
        }
        this.write(0x600100, chan);
        int value = (this.read(0x600101) ^ 0x800000) << 8 >> 14;
        return 2.288818359375E-5 * (double)value;
    }

    public void setMux(int set) throws REBException {
        this.checkVersion(11, 0);
        if (set < 0 || set >= 4) {
            throw new REBException("Invalid MUX setting value: " + set);
        }
        this.write(0x600200, set);
    }

    public int getNumAspicTemps() throws REBException {
        return this.isVersion(11, 1, 3) ? 6 : 0;
    }

    public int getNumCcdCurrents() throws REBException {
        return this.isVersion(11, 1, 3) ? 48 : 0;
    }

    public boolean testChannel(int chan) {
        try {
            int version = this.getVersion(11);
            Map<Integer, Integer> chanMap = version == 1 ? chanMapReb3 : (version == 3 ? chanMapReb4 : (version == 2 ? chanMapWgreb2 : null));
            return chanMap != null && chanMap.get(chan) != null;
        }
        catch (REBException e) {
            return false;
        }
    }

    private void setMuxReb4(int bias, int sam, int adc, int range) throws REBException {
        this.write(0x600101, sam << 19 | bias << 16 | 0x800 | adc << 5 | range << 1);
    }

    private static void checkStrip(int strip) throws REBException {
        if (strip < 0 || strip >= 3) {
            throw new REBException("Invalid strip number: " + strip);
        }
    }

    private static void checkSide(int side) throws REBException {
        if (side < 0 || side >= 2) {
            throw new REBException("Invalid board side: " + side);
        }
    }

    private static void checkAdc(int adc) throws REBException {
        if (adc < 0 || adc >= 2) {
            throw new REBException("Invalid ADC number: " + adc);
        }
    }

    static {
        chanMapReb3.put(0, 0);
        chanMapReb3.put(1, 1);
        chanMapReb3.put(2, 2);
        chanMapReb3.put(3, 3);
        chanMapReb3.put(12, 4);
        chanMapReb3.put(4, 5);
        chanMapReb3.put(5, 6);
        chanMapReb3.put(6, 7);
        chanMapReb3.put(7, 8);
        chanMapReb3.put(13, 9);
        chanMapReb3.put(15, 10);
        chanMapReb3.put(8, 11);
        chanMapReb3.put(9, 12);
        chanMapReb3.put(10, 13);
        chanMapReb3.put(11, 14);
        chanMapReb3.put(14, 15);
        voltsCfgReb4 = new int[]{5137, 9233, 13329, 1041, 17425, 25617, 29713, 1297, 21521, 5393, 9489, 17681, 21777, 25873, 13585, 29969, 1, 257, 513, 769, 1025, 1281, 1537, 1793};
        voltsScaleReb4 = new double[]{0.001678466796875, 0.001678466796875, 0.001678466796875, 0.001678466796875, 1.52587890625E-4, 0.001678466796875, 0.001678466796875, 0.001678466796875, 0.001678466796875, 1.52587890625E-4, 1.52587890625E-4, 0.001678466796875, 0.001678466796875, 0.001678466796875, 0.001678466796875, 1.52587890625E-4, 0.001678466796875, 0.001678466796875, 0.001678466796875, 0.001678466796875, 0.001678466796875, 0.001678466796875, 0.001678466796875, 0.001678466796875};
        chanMapReb4 = new HashMap<Integer, Integer>();
        chanMapReb4.put(0, 0);
        chanMapReb4.put(1, 1);
        chanMapReb4.put(2, 2);
        chanMapReb4.put(3, 3);
        chanMapReb4.put(12, 4);
        chanMapReb4.put(4, 5);
        chanMapReb4.put(5, 6);
        chanMapReb4.put(6, 7);
        chanMapReb4.put(7, 8);
        chanMapReb4.put(13, 9);
        chanMapReb4.put(15, 10);
        chanMapReb4.put(8, 11);
        chanMapReb4.put(9, 12);
        chanMapReb4.put(10, 13);
        chanMapReb4.put(11, 14);
        chanMapReb4.put(14, 15);
        chanMapReb4.put(31, 16);
        chanMapReb4.put(30, 17);
        chanMapReb4.put(25, 18);
        chanMapReb4.put(24, 19);
        chanMapReb4.put(27, 20);
        chanMapReb4.put(26, 21);
        chanMapReb4.put(32, 22);
        chanMapReb4.put(33, 23);
        voltsScaleWgreb2 = new double[][]{{0.001678466796875, 0.001678466796875, 0.001678466796875, 0.001678466796875, 0.001678466796875, 0.001678466796875, 6.103515625E-4, 1.52587890625E-4}, {6.103515625E-4, 6.103515625E-4, 6.103515625E-4, 6.103515625E-4, 6.103515625E-4, 2.5431315104166665E-6}};
        chanMapWgreb2 = new HashMap<Integer, Integer>();
        chanMapWgreb2.put(16, 0);
        chanMapWgreb2.put(19, 1);
        chanMapWgreb2.put(17, 2);
        chanMapWgreb2.put(18, 3);
        chanMapWgreb2.put(21, 4);
        chanMapWgreb2.put(22, 5);
        chanMapWgreb2.put(23, 6);
        chanMapWgreb2.put(20, 7);
        chanMapWgreb2.put(24, 16);
        chanMapWgreb2.put(25, 17);
        chanMapWgreb2.put(26, 18);
        chanMapWgreb2.put(27, 19);
        chanMapWgreb2.put(28, 20);
        chanMapWgreb2.put(29, 21);
    }
}

