/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.drivers.reb.sim;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.Reader;
import java.util.Random;
import java.util.zip.CRC32;
import java.util.zip.CheckedOutputStream;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.lsst.ccs.drivers.reb.sim.AddressSpace;
import org.lsst.ccs.drivers.reb.sim.RegisterSet;
import org.lsst.ccs.drivers.reb.sim.SequencerSimulationTest;

public class AddressSpaceTest {
    private AddressSpace addressSpace;

    @Before
    public void setUp() {
        this.addressSpace = new AddressSpace();
    }

    @After
    public void tearDown() {
    }

    @Test
    public void testHexReadWrite() throws IOException {
        this.addressSpace.add((RegisterSet)new RegisterSet.ArrayRegisterSet(0x100000, new int[64]));
        this.addressSpace.add((RegisterSet)new RegisterSet.ArrayRegisterSet(0x200000, new int[64]));
        this.addressSpace.add((RegisterSet)new RegisterSet.ArrayRegisterSet(0x300000, new int[64]));
        try (InputStreamReader in = new InputStreamReader(SequencerSimulationTest.class.getResourceAsStream("slac1k.hex"));){
            this.addressSpace.hexLoad((Reader)in);
        }
        CRC32 crc32 = new CRC32();
        try (PrintStream out = new PrintStream(new CheckedOutputStream(System.out, crc32));){
            this.addressSpace.hexDump(out, 0, 0x400000);
            Assert.assertEquals((long)1839023413L, (long)crc32.getValue());
        }
        out = new PrintStream(new CheckedOutputStream(System.out, crc32));
        try {
            this.addressSpace.hexDump(out, 0x200000, 0x300000);
            Assert.assertEquals((long)4079769854L, (long)crc32.getValue());
        }
        finally {
            out.close();
        }
    }

    @Test
    public void testHexReadWrite2() throws IOException {
        int i;
        int n;
        Random random = new Random(12345L);
        for (i = 0x100000; i < 0x100040; i += n) {
            n = 1 + random.nextInt(10);
            this.addressSpace.add((RegisterSet)new RegisterSet.ArrayRegisterSet(i, new int[n]));
        }
        for (i = 0x200000; i < 0x200040; i += n) {
            n = 1 + random.nextInt(10);
            this.addressSpace.add((RegisterSet)new RegisterSet.ArrayRegisterSet(i, new int[n]));
        }
        for (i = 0x300000; i < 0x300040; i += n) {
            n = 1 + random.nextInt(10);
            this.addressSpace.add((RegisterSet)new RegisterSet.ArrayRegisterSet(i, new int[n]));
        }
        try (InputStreamReader in = new InputStreamReader(SequencerSimulationTest.class.getResourceAsStream("slac1k.hex"));){
            this.addressSpace.hexLoad((Reader)in);
        }
        CRC32 crc32 = new CRC32();
        try (PrintStream out = new PrintStream(new CheckedOutputStream(System.out, crc32));){
            this.addressSpace.hexDump(out, 0, 0x400000);
            Assert.assertEquals((long)979920586L, (long)crc32.getValue());
        }
        out = new PrintStream(new CheckedOutputStream(System.out, crc32));
        try {
            this.addressSpace.hexDump(out, 0x200000, 0x300000);
            Assert.assertEquals((long)3204670758L, (long)crc32.getValue());
        }
        finally {
            out.close();
        }
    }
}

