/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.drivers.reb.sim;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Condition;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.lsst.ccs.drivers.reb.sim.AddressSpace;
import org.lsst.ccs.drivers.reb.sim.AutoCloseableReentrantLock;
import org.lsst.ccs.drivers.reb.sim.SequencerSimulation;
import org.lsst.ccs.drivers.reb.sim.SimulationException;

public class SequencerSimulationTest {
    private SequencerSimulation sequencer;
    private AddressSpace addressSpace;
    private final AtomicInteger stateChangeCounter = new AtomicInteger();
    private final AtomicInteger functionCallCounter = new AtomicInteger();
    private final AutoCloseableReentrantLock stateLock = new AutoCloseableReentrantLock();
    private final Condition stateChanged = this.stateLock.newCondition();
    private SequencerSimulation.State currentState;

    private void waitForState(SequencerSimulation.State state) throws InterruptedException, TimeoutException {
        try (AutoCloseableReentrantLock lock = this.stateLock.open();){
            do {
                if (this.currentState != state) continue;
                return;
            } while (this.stateChanged.await(1L, TimeUnit.SECONDS));
            throw new TimeoutException("Timed out waiting for state: " + state);
        }
    }

    private void stateChanged(SequencerSimulation.State state) {
        try (AutoCloseableReentrantLock lock = this.stateLock.open();){
            this.currentState = state;
            this.stateChanged.signalAll();
        }
    }

    @Before
    public void setUp() {
        this.addressSpace = new AddressSpace();
        this.sequencer = new SequencerSimulation(this.addressSpace);
        this.sequencer.addStateListener((oldState, newState) -> {
            this.stateChangeCounter.incrementAndGet();
            this.stateChanged(newState);
        });
        this.sequencer.addFunctionListener((function, infiniteLoop, repetitions) -> this.functionCallCounter.incrementAndGet());
    }

    @After
    public void tearDown() {
        this.sequencer.shutdown();
    }

    @Test
    public void testErrorReset() throws InterruptedException, ExecutionException {
        Future future = this.sequencer.start();
        SequencerSimulation.FinalState state = (SequencerSimulation.FinalState)future.get();
        Assert.assertEquals((Object)SequencerSimulation.State.ERROR, (Object)state.getStateAtEnd());
        Assert.assertTrue((boolean)(state.getException() instanceof SimulationException));
        Assert.assertEquals((long)0L, (long)state.getProgramCounter());
        Assert.assertEquals((long)0x10000000L, (long)this.addressSpace.read(0x390000));
        Assert.assertEquals((Object)SequencerSimulation.State.ERROR, (Object)this.sequencer.getState());
        Assert.assertEquals((long)2L, (long)this.stateChangeCounter.get());
        Assert.assertEquals((long)0L, (long)this.functionCallCounter.get());
        this.addressSpace.write(3735553, 0);
        Assert.assertEquals((long)0L, (long)this.addressSpace.read(0x390000));
        Assert.assertEquals((Object)SequencerSimulation.State.STOPPED, (Object)this.sequencer.getState());
        Assert.assertEquals((long)3L, (long)this.stateChangeCounter.get());
        Assert.assertEquals((long)0L, (long)this.functionCallCounter.get());
    }

    @Test
    public void testEnd() throws InterruptedException, ExecutionException {
        int program = 0x300000;
        this.addressSpace.write(program++, -268435456);
        Future future = this.sequencer.start();
        SequencerSimulation.FinalState state = (SequencerSimulation.FinalState)future.get();
        Assert.assertEquals((Object)SequencerSimulation.State.STOPPED, (Object)state.getStateAtEnd());
        Assert.assertNull((Object)state.getException());
        Assert.assertEquals((long)0L, (long)state.getProgramCounter());
        Assert.assertEquals((long)0L, (long)this.addressSpace.read(0x390000));
        Assert.assertEquals((Object)SequencerSimulation.State.STOPPED, (Object)this.sequencer.getState());
        Assert.assertEquals((long)2L, (long)this.stateChangeCounter.get());
        Assert.assertEquals((long)0L, (long)this.functionCallCounter.get());
    }

    @Test
    public void testStop() throws InterruptedException, ExecutionException, TimeoutException {
        int program = 0x300000;
        this.addressSpace.write(program++, 0x10800001);
        this.addressSpace.write(program++, -268435456);
        Future future = this.sequencer.start();
        this.waitForState(SequencerSimulation.State.LOOPING);
        Assert.assertEquals((Object)SequencerSimulation.State.LOOPING, (Object)this.sequencer.getState());
        this.addressSpace.write(0x320000, 0);
        SequencerSimulation.FinalState state = (SequencerSimulation.FinalState)future.get();
        Assert.assertEquals((Object)SequencerSimulation.State.STOPPED, (Object)state.getStateAtEnd());
        Assert.assertNull((Object)state.getException());
        Assert.assertEquals((long)0L, (long)state.getProgramCounter());
        Assert.assertEquals((long)0L, (long)this.addressSpace.read(0x390000));
        Assert.assertEquals((Object)SequencerSimulation.State.STOPPED, (Object)this.sequencer.getState());
        Assert.assertEquals((long)3L, (long)this.stateChangeCounter.get());
        Assert.assertEquals((long)1L, (long)this.functionCallCounter.get());
    }

    @Test
    public void testStopWithWaveformListener() throws InterruptedException, ExecutionException, TimeoutException {
        int program = 0x300000;
        this.addressSpace.write(program++, 0x10800001);
        this.addressSpace.write(program++, -268435456);
        this.sequencer.addWaveformListener((oldState, newState, nanos) -> {});
        Future future = this.sequencer.start();
        this.waitForState(SequencerSimulation.State.LOOPING);
        Assert.assertEquals((Object)SequencerSimulation.State.LOOPING, (Object)this.sequencer.getState());
        this.addressSpace.write(0x320000, 0);
        SequencerSimulation.FinalState state = (SequencerSimulation.FinalState)future.get();
        Assert.assertEquals((Object)SequencerSimulation.State.STOPPED, (Object)state.getStateAtEnd());
        Assert.assertNull((Object)state.getException());
        Assert.assertEquals((long)0L, (long)state.getProgramCounter());
        Assert.assertEquals((long)0L, (long)this.addressSpace.read(0x390000));
        Assert.assertEquals((Object)SequencerSimulation.State.STOPPED, (Object)this.sequencer.getState());
        Assert.assertEquals((long)3L, (long)this.stateChangeCounter.get());
        Assert.assertEquals((long)1L, (long)this.functionCallCounter.get());
    }

    @Test
    public void testStep() throws InterruptedException, ExecutionException, TimeoutException {
        int program = 0x300000;
        this.addressSpace.write(program++, 0x10800001);
        this.addressSpace.write(program++, -268435456);
        Future future = this.sequencer.start();
        this.waitForState(SequencerSimulation.State.LOOPING);
        Assert.assertEquals((Object)SequencerSimulation.State.LOOPING, (Object)this.sequencer.getState());
        this.addressSpace.write(0x310000, 0);
        SequencerSimulation.FinalState state = (SequencerSimulation.FinalState)future.get();
        Assert.assertEquals((Object)SequencerSimulation.State.STOPPED, (Object)state.getStateAtEnd());
        Assert.assertNull((Object)state.getException());
        Assert.assertEquals((long)1L, (long)state.getProgramCounter());
        Assert.assertEquals((long)0L, (long)this.addressSpace.read(0x390000));
        Assert.assertEquals((Object)SequencerSimulation.State.STOPPED, (Object)this.sequencer.getState());
        Assert.assertEquals((long)4L, (long)this.stateChangeCounter.get());
        Assert.assertEquals((long)1L, (long)this.functionCallCounter.get());
    }

    @Test
    public void testOpcode() throws InterruptedException, TimeoutException, ExecutionException {
        int program = 0x300000;
        program += 8;
        this.addressSpace.write(program++, 0x10800001);
        this.addressSpace.write(program++, -268435456);
        Future future = this.sequencer.trigger(2);
        this.waitForState(SequencerSimulation.State.LOOPING);
        Assert.assertEquals((Object)SequencerSimulation.State.LOOPING, (Object)this.sequencer.getState());
        this.sequencer.trigger(31);
        SequencerSimulation.FinalState state = (SequencerSimulation.FinalState)future.get();
        Assert.assertEquals((Object)SequencerSimulation.State.STOPPED, (Object)state.getStateAtEnd());
        Assert.assertNull((Object)state.getException());
        Assert.assertEquals((long)9L, (long)state.getProgramCounter());
        Assert.assertEquals((long)0L, (long)this.addressSpace.read(0x390000));
        Assert.assertEquals((Object)SequencerSimulation.State.STOPPED, (Object)this.sequencer.getState());
        Assert.assertEquals((long)4L, (long)this.stateChangeCounter.get());
        Assert.assertEquals((long)1L, (long)this.functionCallCounter.get());
    }

    @Test
    public void testStepWithWaveformListener() throws InterruptedException, ExecutionException, TimeoutException {
        int program = 0x300000;
        this.addressSpace.write(program++, 0x10800001);
        this.addressSpace.write(program++, -268435456);
        this.sequencer.addWaveformListener((oldState, newState, nanos) -> {});
        Future future = this.sequencer.start();
        this.waitForState(SequencerSimulation.State.LOOPING);
        Assert.assertEquals((Object)SequencerSimulation.State.LOOPING, (Object)this.sequencer.getState());
        this.addressSpace.write(0x310000, 0);
        SequencerSimulation.FinalState state = (SequencerSimulation.FinalState)future.get();
        Assert.assertEquals((Object)SequencerSimulation.State.STOPPED, (Object)state.getStateAtEnd());
        Assert.assertNull((Object)state.getException());
        Assert.assertEquals((long)1L, (long)state.getProgramCounter());
        Assert.assertEquals((long)0L, (long)this.addressSpace.read(0x390000));
        Assert.assertEquals((Object)SequencerSimulation.State.STOPPED, (Object)this.sequencer.getState());
        Assert.assertEquals((long)4L, (long)this.stateChangeCounter.get());
        Assert.assertEquals((long)1L, (long)this.functionCallCounter.get());
    }

    @Test
    public void testHexLoad() throws IOException, InterruptedException, ExecutionException, Exception {
        try (InputStreamReader in = new InputStreamReader(SequencerSimulationTest.class.getResourceAsStream("slac1k.hex"));){
            this.addressSpace.hexLoad((Reader)in);
        }
        Future future = this.sequencer.start();
        SequencerSimulation.FinalState state = (SequencerSimulation.FinalState)future.get();
        Assert.assertEquals((Object)SequencerSimulation.State.STOPPED, (Object)state.getStateAtEnd());
        Assert.assertNull((Object)state.getException());
        Assert.assertEquals((long)3L, (long)state.getProgramCounter());
        Assert.assertEquals((long)0L, (long)this.addressSpace.read(0x390000));
        Assert.assertEquals((Object)SequencerSimulation.State.STOPPED, (Object)this.sequencer.getState());
        Assert.assertEquals((long)2L, (long)this.stateChangeCounter.get());
        Assert.assertEquals((long)3L, (long)this.functionCallCounter.get());
        AtomicInteger transitions = new AtomicInteger();
        AtomicLong totalNanos = new AtomicLong();
        this.sequencer.addWaveformListener((oldState, newState, nanos) -> {
            transitions.getAndIncrement();
            totalNanos.getAndAdd(nanos);
        });
        future = this.sequencer.start();
        state = (SequencerSimulation.FinalState)future.get();
        Assert.assertEquals((Object)SequencerSimulation.State.STOPPED, (Object)state.getStateAtEnd());
        Assert.assertNull((Object)state.getException());
        Assert.assertEquals((long)3L, (long)state.getProgramCounter());
        Assert.assertEquals((long)0L, (long)this.addressSpace.read(0x390000));
        Assert.assertEquals((Object)SequencerSimulation.State.STOPPED, (Object)this.sequencer.getState());
        Assert.assertEquals((long)4L, (long)this.stateChangeCounter.get());
        Assert.assertEquals((long)6L, (long)this.functionCallCounter.get());
        Assert.assertEquals((long)2052L, (long)transitions.get());
        Assert.assertEquals((long)0x190190L, (long)totalNanos.get());
    }

    @Test
    public void testShutdown() throws InterruptedException, ExecutionException, TimeoutException {
        int program = 0x300000;
        this.addressSpace.write(program++, 0x10800001);
        this.addressSpace.write(program++, -268435456);
        Future future = this.sequencer.start();
        this.waitForState(SequencerSimulation.State.LOOPING);
        Assert.assertEquals((Object)SequencerSimulation.State.LOOPING, (Object)this.sequencer.getState());
        this.sequencer.shutdown();
        SequencerSimulation.FinalState state = (SequencerSimulation.FinalState)future.get();
        Assert.assertEquals((Object)SequencerSimulation.State.ERROR, (Object)state.getStateAtEnd());
        Assert.assertTrue((boolean)(state.getException() instanceof InterruptedException));
        try {
            this.sequencer.start();
            Assert.fail((String)"Shold not reach here");
        }
        catch (SimulationException simulationException) {
            // empty catch block
        }
        this.addressSpace.write(3735553, 0);
        try {
            this.sequencer.start();
            Assert.fail((String)"Shold not reach here");
        }
        catch (RejectedExecutionException rejectedExecutionException) {
            // empty catch block
        }
    }

    @Test
    public void testStackDepth() throws InterruptedException, ExecutionException {
        int program = 0x300000;
        this.addressSpace.write(program++, 0x50000001);
        this.addressSpace.write(program++, -268435456);
        Future future = this.sequencer.start();
        SequencerSimulation.FinalState state = (SequencerSimulation.FinalState)future.get();
        Assert.assertEquals((Object)SequencerSimulation.State.ERROR, (Object)state.getStateAtEnd());
        Assert.assertTrue((boolean)(state.getException() instanceof SimulationException));
        Assert.assertEquals((long)0L, (long)state.getProgramCounter());
        Assert.assertEquals((long)0x10000000L, (long)this.addressSpace.read(0x390000));
        Assert.assertEquals((Object)SequencerSimulation.State.ERROR, (Object)this.sequencer.getState());
    }

    @Test
    public void testRenormalize() throws InterruptedException, ExecutionException, TimeoutException {
        int program = 0x300000;
        this.addressSpace.write(program++, 0x10800001);
        this.addressSpace.write(program++, -268435456);
        this.sequencer.setRenormalization(100000);
        Future future = this.sequencer.start();
        this.waitForState(SequencerSimulation.State.LOOPING);
        Assert.assertEquals((Object)SequencerSimulation.State.LOOPING, (Object)this.sequencer.getState());
        SequencerSimulation.FinalState state = (SequencerSimulation.FinalState)future.get();
        Assert.assertEquals((Object)SequencerSimulation.State.STOPPED, (Object)state.getStateAtEnd());
        Assert.assertNull((Object)state.getException());
        Assert.assertEquals((long)1L, (long)state.getProgramCounter());
        Assert.assertEquals((long)0L, (long)this.addressSpace.read(0x390000));
        Assert.assertEquals((Object)SequencerSimulation.State.STOPPED, (Object)this.sequencer.getState());
        Assert.assertEquals((long)4L, (long)this.stateChangeCounter.get());
        Assert.assertEquals((long)1L, (long)this.functionCallCounter.get());
    }

    @Test
    public void testRenormalizeWithStop() throws InterruptedException, ExecutionException, TimeoutException {
        int program = 0x300000;
        this.addressSpace.write(program++, 0x10800001);
        this.addressSpace.write(program++, -268435456);
        this.sequencer.setRenormalization(100000);
        Future future = this.sequencer.start();
        this.waitForState(SequencerSimulation.State.LOOPING);
        Assert.assertEquals((Object)SequencerSimulation.State.LOOPING, (Object)this.sequencer.getState());
        this.addressSpace.write(0x320000, 0);
        SequencerSimulation.FinalState state = (SequencerSimulation.FinalState)future.get();
        Assert.assertEquals((Object)SequencerSimulation.State.STOPPED, (Object)state.getStateAtEnd());
        Assert.assertNull((Object)state.getException());
        Assert.assertEquals((long)0L, (long)state.getProgramCounter());
        Assert.assertEquals((long)0L, (long)this.addressSpace.read(0x390000));
        Assert.assertEquals((Object)SequencerSimulation.State.STOPPED, (Object)this.sequencer.getState());
        Assert.assertEquals((long)3L, (long)this.stateChangeCounter.get());
        Assert.assertEquals((long)1L, (long)this.functionCallCounter.get());
    }

    @Test
    public void testRenormalizeWithWaveformListener() throws InterruptedException, ExecutionException, TimeoutException {
        int program = 0x300000;
        this.addressSpace.write(program++, 0x10800001);
        this.addressSpace.write(program++, -268435456);
        this.sequencer.setRenormalization(100000);
        this.sequencer.addWaveformListener((oldState, newState, nanos) -> {});
        Future future = this.sequencer.start();
        this.waitForState(SequencerSimulation.State.LOOPING);
        Assert.assertEquals((Object)SequencerSimulation.State.LOOPING, (Object)this.sequencer.getState());
        SequencerSimulation.FinalState state = (SequencerSimulation.FinalState)future.get();
        Assert.assertEquals((Object)SequencerSimulation.State.STOPPED, (Object)state.getStateAtEnd());
        Assert.assertNull((Object)state.getException());
        Assert.assertEquals((long)1L, (long)state.getProgramCounter());
        Assert.assertEquals((long)0L, (long)this.addressSpace.read(0x390000));
        Assert.assertEquals((Object)SequencerSimulation.State.STOPPED, (Object)this.sequencer.getState());
        Assert.assertEquals((long)3L, (long)this.stateChangeCounter.get());
        Assert.assertEquals((long)1L, (long)this.functionCallCounter.get());
    }
}

