package org.lsst.ccs.drivers.reb.sim;

/**
 * An exception to be thrown by the REB/DAQ simulation classes
 * @author tonyj
 */
public class SimulationException extends RuntimeException {
    
    /**
     * Create a simulation exception from a format string and list of arguments.
     * @param format A format string 
     * @param args Arguments to be substituted into the format string
     * @see java.util.Formatter
     */
    public SimulationException(String format, Object... args) {
        this(String.format(format, args));
    }

    /**
     * Create a simulation exception from a simple message
     * @param message
     */
    public SimulationException(String message) {
        super(message);
    }
    
}
