package org.lsst.ccs.drivers.reb.sim;

import java.nio.ByteBuffer;
import java.util.Properties;
import org.lsst.ccs.bootstrap.BootstrapResourceUtils;
import org.lsst.ccs.drivers.reb.Image;
import org.lsst.ccs.drivers.reb.ImageClient;

/**
 * A simulated image to be returned from the image client. The current Image
 * class is a little strange, which makes is jump through some hoops here, which
 * we should probably fix.
 *
 * @author tonyj
 */
public class SimulatedImage extends Image {

    private ByteBuffer data;

    //THIS TEMPORARY UNTIL TONY WILL FILL THEM OUT WITH INFORMATION FROM THE SEQUENCER
    private int numberOfColums = 544, numberOfRows = 2048;

    private final Properties props = BootstrapResourceUtils.getBootstrapSystemProperties();

    SimulatedImage(ImageClient.Impl client) {
        super(0L, 0, 0, 0, 0, 0, 0, 0, 0L, client);
    }

    public int getNumberOfColumns() {
        return numberOfColums;
    }

    public void setNumberOfColumns(int numberOfColums) {
        this.numberOfColums = numberOfColums;
    }

    public int getNumberOfRows() {
        return numberOfRows;
    }

    public void setNumberOfRows(int numberOfRows) {
        this.numberOfRows = numberOfRows;
    }

    void setSchema(int schema) {
        this.schema = schema;
    }

    void setTag(long tag) {
        this.tag = tag;
    }

    void setLength(int length) {
        this.length = length;
    }

    void setFormat(int format) {
        this.format = format;
    }

    void setVersion(int version) {
        this.version = version;
    }

    void setAddress(int address) {
        this.address = address;
    }

    void setCluster(int cluster) {
        this.cluster = cluster;
    }

    void setElement(int element) {
        this.element = element;
    }

    void setData(ByteBuffer data) {
        this.data = data;
    }

    @Override
    public ByteBuffer getData() {
        return (data != null && data.limit() > 0) ? data.asReadOnlyBuffer()
                : null;
    }

    //Method to set the register VALUSE
    public void setRegisters(int[] registers) {
        if (registers != null) {
            this.registers = registers;
        }
    }

    void setName(String imageName) {
        this.name = imageName;
    }

    void setRebType(int rebType) {

        //TODO: This should not be needed.
        String rebName = props.getProperty("org.lsst.ccs.drivers.reb.sim.REBType", "REB");
        if ("WREB".equals(rebName)) {
            rebType = REB_TYPE_WAVEFRONT;
        }

        super.sensorType = rebType;
        switch (rebType) {
            case REB_TYPE_SCIENCE:
                super.numCcds = 3;
                break;
            case REB_TYPE_WAVEFRONT:
                super.numCcds = 1;
                break;
            case REB_TYPE_GUIDER:
                super.numCcds = 2;
                break;
        }
    }
}
