/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.drivers.reb;

import java.util.HashMap;
import java.util.Map;
import org.lsst.ccs.drivers.reb.BaseSet;
import org.lsst.ccs.drivers.reb.REBException;
import org.lsst.ccs.drivers.reb.RegClient;

public class SlowAdcs
extends BaseSet {
    public static final int REG_TEMP_SLCT = 0x600100;
    public static final int REG_TEMP_READ = 0x600101;
    public static final int REG_TEMP_MUX = 0x600200;
    public static final int TEMP_CABAC_TOP = 0;
    public static final int TEMP_CABAC_BOTTOM = 1;
    public static final int TEMP_ASPIC_TOP = 2;
    public static final int TEMP_ASPIC_BOTTOM = 3;
    public static final int NUM_TEMPS = 4;
    public static final int MUX_T_B_SLOW = 0;
    public static final int MUX_T_FAST_B_SLOW = 1;
    public static final int MUX_T_SLOW_B_FAST = 2;
    public static final int MUX_T_B_FAST = 3;
    public static final int NUM_MUX_SET = 4;
    public static final int REG_ASPIC_START = 0x600100;
    public static final int REG_ASPIC_READ = 0x601000;
    public static final int REG_MUX_CONFIG = 0x600101;
    public static final int REG_MUX_READ = 0x601010;
    public static final int NUM_ASPIC_TEMPS = 6;
    public static final int NUM_BIAS_VOLTS = 16;
    public static final int NUM_CURR_CHANS = 8;
    public static final int CHAN_OD = 0;
    public static final int CHAN_OG = 1;
    public static final int CHAN_RD = 2;
    public static final int CHAN_GD = 3;
    public static final int CHAN_VREF5 = 4;
    public static final int CHAN_VREF25 = 5;
    public static final int CHAN_OD_0 = 0;
    public static final int CHAN_OG_0 = 1;
    public static final int CHAN_RD_0 = 2;
    public static final int CHAN_GD_0 = 3;
    public static final int CHAN_OD_1 = 4;
    public static final int CHAN_OG_1 = 5;
    public static final int CHAN_RD_1 = 6;
    public static final int CHAN_GD_1 = 7;
    public static final int CHAN_OD_2 = 8;
    public static final int CHAN_OG_2 = 9;
    public static final int CHAN_RD_2 = 10;
    public static final int CHAN_GD_2 = 11;
    public static final int CHAN_VREF5_0 = 12;
    public static final int CHAN_VREF5_1 = 13;
    public static final int CHAN_VREF5_2 = 14;
    public static final int CHAN_VREF25_1 = 15;
    public static final double VOLT_SCALE_0 = 2.288818359375E-5;
    public static final double VOLT_SCALE = 0.001220703125;
    public static final double VOLT_SCALE_HI = 0.013427734375;
    public static final double CURR_SCALE = 1.220703125E-6;
    public static final double TEMP_OFFSET = 442.32142857142856;
    public static final double TEMP_SCALE = -0.21798270089285715;
    private static final int[][] voltsCfg = new int[][]{{60, 92, 124, 28, 156}, {220, 252, 29, 188, 61, 93}, {157, 189, 221, 125, 253}};
    private static final double[][] voltsScale = new double[][]{{0.013427734375, 0.013427734375, 0.013427734375, 0.013427734375, 0.001220703125}, {0.013427734375, 0.013427734375, 0.013427734375, 0.013427734375, 0.001220703125, 0.001220703125}, {0.013427734375, 0.013427734375, 0.013427734375, 0.013427734375, 0.001220703125}};
    private static final Map<Integer, Integer> chanMap = new HashMap<Integer, Integer>();

    public SlowAdcs() {
    }

    public SlowAdcs(RegClient reg) {
        super(reg);
    }

    public int readDirect(int config) throws REBException {
        this.checkVersion(11, 1);
        this.write(0x600101, config);
        return this.read(0x601010) & 0xFFF;
    }

    public double[] readAspicTemps(int first, int count) throws REBException {
        this.checkVersion(11, 1);
        if (first < 0 || count < 0 || first + count > 6) {
            throw new REBException("Invalid ASPIC temperature range");
        }
        double[] data = new double[count];
        this.write(0x600100, 0);
        for (int j = 0; j < count; ++j) {
            int value = this.read(0x601000 + first + j) & 0xFFF;
            data[j] = 442.32142857142856 + -0.21798270089285715 * (double)value;
        }
        return data;
    }

    public double readAspicTemp(int strip, int side) throws REBException {
        this.checkVersion(11, 1);
        SlowAdcs.checkStrip(strip);
        SlowAdcs.checkSide(side);
        this.write(0x600101, 4 * strip + side + 2);
        return 442.32142857142856 + (double)(this.read(0x601010) & 0xFFF) * -0.21798270089285715;
    }

    public double readVoltage(int strip, int chan) throws REBException {
        this.checkVersion(11, 1);
        SlowAdcs.checkStrip(strip);
        try {
            this.write(0x600101, voltsCfg[strip][chan]);
            return (double)(this.read(0x601010) & 0xFFF) * voltsScale[strip][chan];
        }
        catch (IndexOutOfBoundsException e) {
            throw new REBException("Invalid voltage channel: " + chan);
        }
    }

    public double readVoltage(int chan) throws REBException {
        Integer desc = chanMap.get(chan);
        if (desc == null) {
            throw new REBException("Invalid voltage channel: " + chan);
        }
        return this.readVoltage(desc >> 4, (int)(desc & 0xF));
    }

    public double readCurrent(int strip, int side, int chan) throws REBException {
        this.checkVersion(11, 1);
        SlowAdcs.checkStrip(strip);
        SlowAdcs.checkSide(side);
        if (chan < 0 || chan >= 8) {
            throw new REBException("Invalid current channel: " + chan);
        }
        this.write(0x600101, 4 * strip + side | chan << 5 | 0x10);
        return (double)(this.read(0x601010) & 0xFFF) * 1.220703125E-6;
    }

    public double readCurrent(int chan) throws REBException {
        return this.readCurrent(chan >> 4, chan >> 3 & 1, chan & 7);
    }

    public double readSlow(int chan) throws REBException {
        this.checkVersion(11, 0);
        if (chan < 0 || chan >= 4) {
            throw new REBException("Invalid slow ADC channel number");
        }
        this.write(0x600100, chan);
        int value = (this.read(0x600101) ^ 0x800000) << 8 >> 14;
        return 2.288818359375E-5 * (double)value;
    }

    public void setMux(int set) throws REBException {
        this.checkVersion(11, 0);
        if (set < 0 || set >= 4) {
            throw new REBException("Invalid MUX setting value: " + set);
        }
        this.write(0x600200, set);
    }

    public int getNumAspicTemps() throws REBException {
        return this.getVersion(11, true) == 1 ? 6 : 0;
    }

    public int getNumBiasVolts() throws REBException {
        return this.getVersion(11, true) == 1 ? 16 : 0;
    }

    private static void checkStrip(int strip) throws REBException {
        if (strip < 0 || strip >= 3) {
            throw new REBException("Invalid strip number: " + strip);
        }
    }

    private static void checkSide(int side) throws REBException {
        if (side < 0 || side >= 2) {
            throw new REBException("Invalid board side: " + side);
        }
    }

    static {
        chanMap.put(3, 3);
        chanMap.put(0, 0);
        chanMap.put(1, 1);
        chanMap.put(2, 2);
        chanMap.put(12, 4);
        chanMap.put(7, 19);
        chanMap.put(4, 16);
        chanMap.put(5, 17);
        chanMap.put(6, 18);
        chanMap.put(13, 20);
        chanMap.put(15, 21);
        chanMap.put(11, 35);
        chanMap.put(8, 32);
        chanMap.put(9, 33);
        chanMap.put(10, 34);
        chanMap.put(14, 36);
    }
}

